/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1.decisionservices;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDecisionServicesTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNDecisionServicesTest.class);

    public DMNDecisionServicesTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testBasic() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-decision-services.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.checkDSwithInputData(runtime, dmnModel);
        this.checkDSwithInputDecision(runtime, dmnModel);
        this.checkDSwithInputDecision2(runtime, dmnModel);
    }

    private void checkDSwithInputData(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A only as output knowing D and E");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.is((Object)"de"));
    }

    private void checkDSwithInputDecision(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A Only Knowing B and C");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.nullValue());
    }

    private void checkDSwithInputDecision2(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        context.set("B", (Object)"inB");
        context.set("C", (Object)"inC");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "A Only Knowing B and C");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("A"), (Matcher)CoreMatchers.is((Object)"inBinC"));
    }

    @Test
    public void testDSInLiteralExpression() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionServicesInLiteralExpression.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xyde"));
    }

    @Test
    public void testDSInLiteralExpressionWithBKM() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionServicesInLiteralExpressionWithBKM.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xydemn"));
    }

    @Test
    public void testDSInLiteralExpressionWithBKMUsingInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionServicesInLiteralExpressionWithBKMUsingInvocation.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"xydemn"));
    }

    @Test
    public void testDSInLiteralExpressionOnlyfromBKMUsingInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionServicesInLiteralExpressionOnlyFromBKMUsingInvocation.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("D", (Object)"d");
        context.set("E", (Object)"e");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Decide based on A and DS"), (Matcher)CoreMatchers.is((Object)"demn"));
    }

    @Test
    public void testMixtypeDS() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"mixtype-DS.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_c9885563-aa54-4c7b-ae8a-738cfd29b544", "mixtype DS");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(1980L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        MatcherAssert.assertThat((Object)result.get("Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(38L)));
        MatcherAssert.assertThat((Object)result.get("is Person an adult"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, ds all")));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(18L))));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS all")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, DS encapsulate")));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS encapsulate")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, DS greet adult")));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)true)));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS greet adult")), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
        this.testMixtypeDS_checkDSall(runtime, dmnModel);
        this.testMixtypeDS_checkDSencapsulate(runtime, dmnModel);
        this.testMixtypeDS_checkDSgreetadult(runtime, dmnModel);
    }

    private void testMixtypeDS_checkDSall(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(2008L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS all");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(10L))));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    private void testMixtypeDS_checkDSencapsulate(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person year of birth", (Object)BigDecimal.valueOf(2008L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS encapsulate");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Person age"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    private void testMixtypeDS_checkDSgreetadult(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(10L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS greet adult");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the Person"), (Matcher)CoreMatchers.is((Object)"Hello, John")));
        MatcherAssert.assertThat((Object)dmnResult.getDecisionResultByName("Person age"), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person an adult"), (Matcher)CoreMatchers.is((Object)false)));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"hardcoded now"), (Matcher)Matchers.anything())));
    }

    @Test
    public void testDSForTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionService20180718.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_6eef3a7c-bb0d-40bb-858d-f9067789c18a", "Decision Service 20180718");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.testDSForTypeCheck_runNormal(runtime, dmnModel);
        this.testDSForTypeCheck_runAllDecisionsWithWrongTypes(runtime, dmnModel);
        this.testDSForTypeCheck_runDecisionService_Normal(runtime, dmnModel);
        this.testDSForTypeCheck_runDecisionService_WithWrongTypes(runtime, dmnModel);
    }

    private void testDSForTypeCheck_runNormal(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(21L));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("Greet the person"), (Matcher)CoreMatchers.is((Object)"Hello, John"));
        MatcherAssert.assertThat((Object)result.get("is Person at age allowed"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)result.get("Final Decision"), (Matcher)CoreMatchers.is((Object)"Hello, John; you are allowed"));
    }

    private void testDSForTypeCheck_runAllDecisionsWithWrongTypes(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)BigDecimal.valueOf(21L));
        context.set("Person age", (Object)"John");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void testDSForTypeCheck_runDecisionService_Normal(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)"John");
        context.set("Person age", (Object)BigDecimal.valueOf(21L));
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS given inputdata");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Greet the person"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"is Person at age allowed"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.get("Final Decision"), (Matcher)CoreMatchers.is((Object)"Hello, John; you are allowed"));
    }

    private void testDSForTypeCheck_runDecisionService_WithWrongTypes(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("Person name", (Object)BigDecimal.valueOf(21L));
        context.set("Person age", (Object)"John");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "DS given inputdata");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.getMessages().stream().anyMatch(m -> m.getSourceId().equals("_cf49add9-84a4-40ac-8306-1eea599ff43c") && m.getLevel() == Message.Level.WARNING), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDSSingletonOrMultipleOutputDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Decision-Services-singleton-or-multiple-output-decisions.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b4ebfbf2-8608-4297-9662-be70bab01974", "Decision Services singleton or multiple output decisions");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        MatcherAssert.assertThat((Object)result.get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
        MatcherAssert.assertThat((Object)result.get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
        MatcherAssert.assertThat((Object)result.get("eval DS with singleton value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value")));
        MatcherAssert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L))));
        DMNResult dmnResultDSSingleton = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with singleton value");
        LOG.debug("{}", (Object)dmnResultDSSingleton);
        dmnResultDSSingleton.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResultDSSingleton.getMessages()), (Object)dmnResultDSSingleton.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
        MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)Matchers.anything())));
        DMNResult dmnResultMultiple = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with multiple output decisions");
        LOG.debug("{}", (Object)dmnResultMultiple);
        dmnResultMultiple.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResultMultiple.getMessages()), (Object)dmnResultMultiple.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
        MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
        MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)Matchers.anything())));
    }

    @Test
    public void testDSSingletonOrMultipleOutputDecisions_OVERRIDE() {
        try {
            System.setProperty("org.kie.dmn.decisionservice.coercesingleton", "false");
            DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Decision-Services-singleton-or-multiple-output-decisions.dmn", ((Object)((Object)this)).getClass());
            DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b4ebfbf2-8608-4297-9662-be70bab01974", "Decision Services singleton or multiple output decisions");
            MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            DMNContext emptyContext = DMNFactory.newContext();
            DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
            LOG.debug("{}", (Object)dmnResult);
            dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            DMNContext result = dmnResult.getContext();
            MatcherAssert.assertThat((Object)result.get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
            MatcherAssert.assertThat((Object)result.get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
            MatcherAssert.assertThat((Object)result.get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
            MatcherAssert.assertThat((Object)((Map)result.get("eval DS with singleton value")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)CoreMatchers.is((Object)"a string Value")));
            MatcherAssert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value")));
            MatcherAssert.assertThat((Object)((Map)result.get("eval DS with multiple output decisions")), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L))));
            DMNResult dmnResultDSSingleton = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with singleton value");
            LOG.debug("{}", (Object)dmnResultDSSingleton);
            dmnResultDSSingleton.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResultDSSingleton.getMessages()), (Object)dmnResultDSSingleton.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().get("a Value"), (Matcher)CoreMatchers.is((Object)"a string Value"));
            MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a String Value"), (Matcher)Matchers.anything())));
            MatcherAssert.assertThat((Object)dmnResultDSSingleton.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Number Value"), (Matcher)Matchers.anything())));
            DMNResult dmnResultMultiple = runtime.evaluateDecisionService(dmnModel, emptyContext, "DS with multiple output decisions");
            LOG.debug("{}", (Object)dmnResultMultiple);
            dmnResultMultiple.getDecisionResults().forEach(x -> LOG.debug("{}", x));
            MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResultMultiple.getMessages()), (Object)dmnResultMultiple.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().get("a String Value"), (Matcher)CoreMatchers.is((Object)"a String Value"));
            MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().get("a Number Value"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
            MatcherAssert.assertThat((Object)dmnResultMultiple.getContext().getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"a Value"), (Matcher)Matchers.anything())));
        }
        catch (Exception e) {
            LOG.error("{}", (Object)e.getLocalizedMessage(), (Object)e);
            throw e;
        }
        finally {
            System.clearProperty("org.kie.dmn.decisionservice.coercesingleton");
            Assert.assertNull((Object)System.getProperty("org.kie.dmn.decisionservice.coercesingleton"));
        }
    }

    @Test
    public void testImportDS() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"DecisionService20180718.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ImportDecisionService20180718.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_0ff3708a-c861-4a96-b85c-7b882f18b7a1", "Import Decision Service 20180718");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.testImportDS_testEvaluateAll(runtime, dmnModel);
        this.testImportDS_testEvaluateDS(runtime, dmnModel);
    }

    private void testImportDS_testEvaluateAll(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("L1 person name", (Object)"L1 Import John");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("invoke imported DS"), (Matcher)CoreMatchers.is((Object)"Hello, L1 Import John; you are allowed"));
        MatcherAssert.assertThat((Object)result.get("Prefixing"), (Matcher)CoreMatchers.is((Object)"Hello, L1 Import John"));
        MatcherAssert.assertThat((Object)result.get("final Import L1 decision"), (Matcher)CoreMatchers.is((Object)"Hello, L1 Import John the result of invoking the imported DS is: Hello, L1 Import John; you are allowed"));
    }

    private void testImportDS_testEvaluateDS(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("L1 person name", (Object)"L1 Import Evaluate DS NAME");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "Import L1 DS");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"invoke imported DS"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Prefixing"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.get("final Import L1 decision"), (Matcher)CoreMatchers.is((Object)"Hello, L1 Import Evaluate DS NAME the result of invoking the imported DS is: Hello, L1 Import Evaluate DS NAME; you are allowed"));
    }

    @Test
    public void testTransitiveImportDS() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"DecisionService20180718.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ImportDecisionService20180718.dmn", "ImportofImportDecisionService20180718.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_6698dc07-cc43-47ec-8187-8faa7d8c35ba", "Import of Import Decision Service 20180718");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        this.testTransitiveImportDS_testEvaluateAll(runtime, dmnModel);
        this.testTransitiveImportDS_testEvaluateDS(runtime, dmnModel);
    }

    private void testTransitiveImportDS_testEvaluateAll(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("L2 Person name", (Object)"L2 Bob");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("L2 Invoking the L1 import"), (Matcher)CoreMatchers.is((Object)"Hello, L2 Bob the result of invoking the imported DS is: Hello, L2 Bob; you are allowed"));
        MatcherAssert.assertThat((Object)result.get("Final L2 Decision"), (Matcher)CoreMatchers.is((Object)"The result of invoking the L1 DS was: Hello, L2 Bob the result of invoking the imported DS is: Hello, L2 Bob; you are allowed"));
    }

    private void testTransitiveImportDS_testEvaluateDS(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        context.set("L2 Person name", (Object)"L2 Bob DS");
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "L2 DS");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"L2 Invoking the L1 import"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.get("Final L2 Decision"), (Matcher)CoreMatchers.is((Object)"The result of invoking the L1 DS was: Hello, L2 Bob DS the result of invoking the imported DS is: Hello, L2 Bob DS; you are allowed"));
    }

    @Test
    public void testDecisionServiceCompiler20180830() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DecisionServiceABC.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_2443d3f5-f178-47c6-a0c9-b1fd1c933f60", "Drawing 1");
        MatcherAssert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNDecisionServicesTest.testDecisionServiceCompiler20180830_testEvaluateDS(runtime, dmnModel);
        DMNDecisionServicesTest.testDecisionServiceCompiler20180830_testEvaluateAll(runtime, dmnModel);
    }

    public static void testDecisionServiceCompiler20180830_testEvaluateAll(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.get("ABC"), (Matcher)CoreMatchers.is((Object)"abc"));
        MatcherAssert.assertThat((Object)result.get("Invoking Decision"), (Matcher)CoreMatchers.is((Object)"abc"));
    }

    public static void testDecisionServiceCompiler20180830_testEvaluateDS(DMNRuntime runtime, DMNModel dmnModel) {
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateDecisionService(dmnModel, context, "Decision Service ABC");
        LOG.debug("{}", (Object)dmnResult);
        dmnResult.getDecisionResults().forEach(x -> LOG.debug("{}", x));
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        MatcherAssert.assertThat((Object)result.getAll(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"Invoking Decision"), (Matcher)Matchers.anything())));
        MatcherAssert.assertThat((Object)result.get("ABC"), (Matcher)CoreMatchers.is((Object)"abc"));
    }
}

