/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1.imports;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DMNTestUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(ImportsTest.class);

    public ImportsTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testImportDependenciesForDTInAContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Imported_Model.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Import_BKM_and_have_a_Decision_Ctx_with_DT.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/definitions/_f27bb64b-6fc7-4e1f-9848-11ba35e0df36", "Imported Model");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c3e08836-7973-4e4d-af2b-d46b23725c13", "Import BKM and have a Decision Ctx with DT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("A Person", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"age", (Object)47)}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("A Decision Ctx with DT").getResult()).isEqualTo((Object)"Respectfully, Hello John!");
    }

    @Test
    public void testImport2BKMs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_say_hello_with_2_bkms.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Say hello decision").getResult()).isEqualTo((Object)"Hello, John");
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult()).isEqualTo((Object)"Hello");
    }

    @Test
    public void testImport2BKMsInvoke() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_invoke_hello_with_2_bkms.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = runtime.newContext();
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("invocation of hello").getResult()).isEqualTo((Object)"Hello, John");
    }

    @Test
    public void testImport2BKMsInvokeUsingInputData() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Do_invoke_hello_with_2_bkms_using_inputdata.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Saying_hello_2_bkms.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_eedf6ecc-f113-4333-ace0-79b783e313e5", "Do invoke hello with 2 bkms");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("Person name", (Object)"Bob");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("what about hello").getResult()).isEqualTo((Object)"Hello, Bob");
    }

    @Test
    public void testImport3Levels() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"L3_Do_say_hello.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Do_say_hello_with_2_bkms.dmn", "Saying_hello_2_bkms.dmn"});
        if (LOG.isDebugEnabled()) {
            runtime.addListener(DMNRuntimeUtil.createListener());
        }
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_16a48e7a-0687-4c2d-b402-42925084fa1a", "Saying hello 2 bkms");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_01a65215-7e0d-47ac-845a-a768f6abf7fe", "Do say hello with 2 bkms");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModelL3 = runtime.getModel("http://www.trisotech.com/dmn/definitions/_820c548c-377d-463e-a62b-bb95ddc4758c", "L3 Do say hello");
        Assertions.assertThat((Object)dmnModelL3).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModelL3.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModelL3.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("Another Name", (Object)"Bob");
        context.set("L2import", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModelL3, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("L3 decision").getResult()).isEqualTo((Object)"Hello, Bob");
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("L3 view on M2").getResult()).isEqualTo((Object)"Hello, John");
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("L3 what about hello").getResult()).isEqualTo((Object)"Hello");
    }

    @Test
    public void testImportHardcodedDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Spell_Greeting.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Import_Spell_Greeting.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_88f4fc88-1eb2-4188-a721-5720cf5565ce", "Spell Greeting");
        Assertions.assertThat((Object)importedModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)importedModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)importedModel.getMessages()), new Object[0])).isFalse();
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_d67f19e9-7835-4cad-9c80-16b8423cc392", "Import Spell Greeting");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("Person Name", (Object)"John");
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Say the Greeting to Person").getResult()).isEqualTo((Object)"Hello, John");
    }

    @Test
    public void testImportTransitiveBaseModel() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9", (String)"Say hello 1ID1D");
    }

    @Test
    public void testImportTransitiveEvaluate2Layers() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        DMNContext context = runtime.newContext();
        context.set("modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Evaluating Say Hello").getResult()).isEqualTo((Object)"Evaluating Say Hello to: Hello, John");
    }

    @Test
    public void testImportTransitiveEvaluate3Layers() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_10435dcd-8774-4575-a338-49dd554a0928", (String)"Model C");
        DMNContext context = runtime.newContext();
        context.set("Model B", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"B.A.John")}))}));
        context.set("Model B2", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"B2.A.John2")}))}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Model C Decision based on Bs").getResult()).isEqualTo((Object)"B: Evaluating Say Hello to: Hello, B.A.John; B2:Evaluating Say Hello to: Hello, B2.A.John2");
    }

    @Test
    public void testImportingID() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Importing_ID.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_24bac498-2a5a-403d-8b44-d407628784c4", (String)"Importing ID");
        DMNContext context = runtime.newContext();
        context.set("my import hello", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"DROOLS-2944")}));
        DMNResult evaluateAll = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)evaluateAll);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Hello decision using imported InputData").getResult()).isEqualTo((Object)"Hello, DROOLS-2944");
    }

    @Test
    public void testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        this.testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(runtime, context -> runtime.evaluateByName(dmnModel, context, new String[]{"modelA.Greet the Person", "Evaluating Say Hello"}));
        this.testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(runtime, context -> runtime.evaluateById(dmnModel, context, new String[]{"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_f7fdaec4-d669-4797-b3b4-12b860de2eb5", "_96df766e-23e1-4aa6-9d5d-545fbe2f1e23"}));
    }

    private void testAllowDMNAPItoEvaluateDirectDependencyImportedDecisions_evaluateResultsAndCheck(DMNRuntime runtime, Function<DMNContext, DMNResult> fn) {
        DMNContext context = runtime.newContext();
        context.set("modelA", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Person name", (Object)"John")}));
        DMNResult evaluateAll = fn.apply(context);
        LOG.debug("{}", (Object)evaluateAll);
        LOG.debug("{}", (Object)evaluateAll.getDecisionResults());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)evaluateAll.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)evaluateAll.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Evaluating Say Hello").getResult()).isEqualTo((Object)"Evaluating Say Hello to: Hello, John");
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("modelA.Greet the Person").getResult()).isEqualTo((Object)"Hello, John");
    }

    @Test
    public void testRetrieveDecisionByIDName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn"});
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        Assertions.assertThat((String)dmnModel.getDecisionById("_96df766e-23e1-4aa6-9d5d-545fbe2f1e23").getName()).isEqualTo("Evaluating Say Hello");
        Assertions.assertThat((String)dmnModel.getDecisionById("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_f7fdaec4-d669-4797-b3b4-12b860de2eb5").getName()).isEqualTo("Greet the Person");
        Assertions.assertThat((Object)dmnModel.getDecisionById("_f7fdaec4-d669-4797-b3b4-12b860de2eb5")).isNull();
        Assertions.assertThat((String)dmnModel.getDecisionByName("Evaluating Say Hello").getId()).isEqualTo("_96df766e-23e1-4aa6-9d5d-545fbe2f1e23");
        Assertions.assertThat((Object)dmnModel.getDecisionByName("Greet the Person")).isNull();
        Assertions.assertThat((String)dmnModel.getDecisionByName("modelA.Greet the Person").getId()).isEqualTo("_f7fdaec4-d669-4797-b3b4-12b860de2eb5");
        Assertions.assertThat((String)dmnModel.getInputById("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9#_4f6c136c-8512-4d71-8bbf-7c9eb6e74063").getName()).isEqualTo("Person name");
        Assertions.assertThat((Object)dmnModel.getInputById("_4f6c136c-8512-4d71-8bbf-7c9eb6e74063")).isNull();
        Assertions.assertThat((Object)dmnModel.getInputByName("Person name")).isNull();
        Assertions.assertThat((String)dmnModel.getInputByName("modelA.Person name").getId()).isEqualTo("_4f6c136c-8512-4d71-8bbf-7c9eb6e74063");
    }

    @Test
    public void testImportChain() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Sayhello1ID1D.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"ModelB.dmn", "ModelB2.dmn", "ModelC.dmn"});
        DMNModelImpl modelA = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9", (String)"Say hello 1ID1D");
        Assertions.assertThat((Map)modelA.getImportChainAliases()).hasSize(0);
        DMNModelImpl modelB = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c", (String)"Model B");
        Assertions.assertThat((Map)modelB.getImportChainAliases()).hasSize(1);
        Assertions.assertThat((Map)modelB.getImportChainAliases()).containsKey((Object)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9");
        Assertions.assertThat((Iterable)((Iterable)modelB.getImportChainAliases().get("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9"))).contains((Object[])new List[]{Collections.singletonList("modelA")});
        DMNModelImpl modelC = (DMNModelImpl)DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_10435dcd-8774-4575-a338-49dd554a0928", (String)"Model C");
        Assertions.assertThat((Map)modelC.getImportChainAliases()).hasSize(3);
        Assertions.assertThat((Map)modelC.getImportChainAliases()).containsKey((Object)"http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c");
        Assertions.assertThat((Iterable)((Iterable)modelC.getImportChainAliases().get("http://www.trisotech.com/dmn/definitions/_2a1d771a-a899-4fef-abd6-fc894332337c"))).contains((Object[])new List[]{Collections.singletonList("Model B")});
        Assertions.assertThat((Map)modelC.getImportChainAliases()).containsKey((Object)"http://www.trisotech.com/definitions/_9d46ece4-a96c-4cb0-abc0-0ca121ac3768");
        Assertions.assertThat((Iterable)((Iterable)modelC.getImportChainAliases().get("http://www.trisotech.com/definitions/_9d46ece4-a96c-4cb0-abc0-0ca121ac3768"))).contains((Object[])new List[]{Collections.singletonList("Model B2")});
        Assertions.assertThat((Map)modelC.getImportChainAliases()).containsKey((Object)"http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9");
        Assertions.assertThat((Iterable)((Iterable)modelC.getImportChainAliases().get("http://www.trisotech.com/dmn/definitions/_ae5b3c17-1ac3-4e1d-b4f9-2cf861aec6d9"))).contains((Object[])new List[]{Arrays.asList("Model B2", "modelA"), Arrays.asList("Model B", "modelA")});
    }
}

