/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.ItemDefNode;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.types.AliasFEELType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNCompilerTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNCompilerTest.class);

    public DMNCompilerTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testItemDefAllowedValuesString() {
        DMNRuntime runtime = this.createRuntime("0003-input-data-string-allowed-values.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0003-input-data-string-allowed-values");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ItemDefNode itemDef = dmnModel.getItemDefinitionByName("tEmploymentStatus");
        Assertions.assertThat((String)itemDef.getName()).isEqualTo("tEmploymentStatus");
        Assertions.assertThat((String)itemDef.getId()).isNull();
        DMNType type = itemDef.getType();
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getName()).isEqualTo("tEmploymentStatus");
        Assertions.assertThat((String)type.getId()).isNull();
        Assertions.assertThat((Object)type).isInstanceOf(SimpleTypeImpl.class);
        SimpleTypeImpl feelType = (SimpleTypeImpl)type;
        EvaluationContextImpl ctx = new EvaluationContextImpl(ClassLoaderUtil.findDefaultClassLoader(), null);
        Assertions.assertThat((Object)feelType.getFeelType()).isInstanceOf(AliasFEELType.class);
        Assertions.assertThat((String)feelType.getFeelType().getName()).isEqualTo("tEmploymentStatus");
        Assertions.assertThat((List)feelType.getAllowedValuesFEEL()).hasSize(4);
        Assertions.assertThat((Boolean)((Boolean)((UnaryTest)feelType.getAllowedValuesFEEL().get(0)).apply((Object)ctx, (Object)"UNEMPLOYED"))).isEqualTo(true);
        Assertions.assertThat((Boolean)((Boolean)((UnaryTest)feelType.getAllowedValuesFEEL().get(1)).apply((Object)ctx, (Object)"EMPLOYED"))).isEqualTo(true);
        Assertions.assertThat((Boolean)((Boolean)((UnaryTest)feelType.getAllowedValuesFEEL().get(2)).apply((Object)ctx, (Object)"SELF-EMPLOYED"))).isEqualTo(true);
        Assertions.assertThat((Boolean)((Boolean)((UnaryTest)feelType.getAllowedValuesFEEL().get(3)).apply((Object)ctx, (Object)"STUDENT"))).isEqualTo(true);
    }

    @Test
    public void testCompositeItemDefinition() {
        DMNRuntime runtime = this.createRuntime("0008-LX-arithmetic.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0008-LX-arithmetic");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ItemDefNode itemDef = dmnModel.getItemDefinitionByName("tLoan");
        Assertions.assertThat((String)itemDef.getName()).isEqualTo("tLoan");
        Assertions.assertThat((String)itemDef.getId()).isEqualTo("tLoan");
        DMNType type = itemDef.getType();
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((String)type.getName()).isEqualTo("tLoan");
        Assertions.assertThat((String)type.getId()).isEqualTo("tLoan");
        Assertions.assertThat((Object)type).isInstanceOf(CompositeTypeImpl.class);
        CompositeTypeImpl compType = (CompositeTypeImpl)type;
        Assertions.assertThat((Map)compType.getFields()).hasSize(3);
        DMNType principal = (DMNType)compType.getFields().get("principal");
        Assertions.assertThat((Object)principal).isNotNull();
        Assertions.assertThat((String)principal.getName()).isEqualTo("number");
        Assertions.assertThat((Object)((SimpleTypeImpl)principal).getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        DMNType rate = (DMNType)compType.getFields().get("rate");
        Assertions.assertThat((Object)rate).isNotNull();
        Assertions.assertThat((String)rate.getName()).isEqualTo("number");
        Assertions.assertThat((Object)((SimpleTypeImpl)rate).getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        DMNType termMonths = (DMNType)compType.getFields().get("termMonths");
        Assertions.assertThat((Object)termMonths).isNotNull();
        Assertions.assertThat((String)termMonths.getName()).isEqualTo("number");
        Assertions.assertThat((Object)((SimpleTypeImpl)termMonths).getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
    }

    @Test
    public void testCompilationThrowsNPE() {
        try {
            this.createRuntime("compilationThrowsNPE.dmn", ((Object)((Object)this)).getClass());
            Assert.fail((String)"shouldn't have reached here.");
        }
        catch (Exception ex) {
            Assertions.assertThat((String)ex.getMessage()).containsSequence(new CharSequence[]{"Unable to compile DMN model for the resource"});
        }
    }

    @Test
    public void testRecursiveFunctions() {
        DMNRuntime runtime = this.createRuntime("Recursive.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "Recursive");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assert.assertFalse((boolean)this.evaluateModel(runtime, dmnModel, DMNFactory.newContext()).hasErrors());
    }

    @Test
    public void testImport() {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("Importing_Model.dmn", ((Object)((Object)this)).getClass(), new String[]{"Imported_Model.dmn"});
        DMNModel importedModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_f27bb64b-6fc7-4e1f-9848-11ba35e0df36", "Imported Model");
        Assertions.assertThat((Object)importedModel).isNotNull();
        for (Object message : importedModel.getMessages()) {
            LOG.debug("{}", message);
        }
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_f79aa7a4-f9a3-410a-ac95-bea496edab52", "Importing Model");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        for (DMNMessage message : dmnModel.getMessages()) {
            LOG.debug("{}", (Object)message);
        }
        DMNContext context = runtime.newContext();
        context.set("A Person", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"age", (Object)47)}));
        DMNResult evaluateAll = this.evaluateModel(runtime, dmnModel, context);
        for (DMNMessage message : evaluateAll.getMessages()) {
            LOG.debug("{}", (Object)message);
        }
        LOG.debug("{}", (Object)evaluateAll);
        Assertions.assertThat((Object)evaluateAll.getDecisionResultByName("Greeting").getResult()).isEqualTo((Object)"Hello John!");
    }
}

