/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.validation.v1_1;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDMNElementReferenceTest
extends AbstractValidatorTest {
    @Test
    public void testELEMREF_NOHASH_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("dmnelementref/ELEMREF_NOHASH.dmn");){
            List validationMessages = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            this.assertValiadationResult(validationMessages);
        }
    }

    @Test
    public void testELEMREF_NOHASH_FileInput() {
        List validationMessages = validator.validate(this.getFile("dmnelementref/ELEMREF_NOHASH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        this.assertValiadationResult(validationMessages);
    }

    @Test
    public void testELEMREF_NOHASH_DefinitionsInput() {
        List validationMessages = validator.validate(this.getDefinitions("dmnelementref/ELEMREF_NOHASH.dmn", "https://github.com/kiegroup/kie-dmn", "ELEMREF_NOHASH"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        this.assertValiadationResult(validationMessages);
    }

    private void assertValiadationResult(List<DMNMessage> validationMessages) {
        ((ListAssert)Assertions.assertThat(validationMessages).as(ValidatorUtil.formatMessages(validationMessages), new Object[0])).hasSize(3);
        Assert.assertTrue((boolean)validationMessages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        Assert.assertTrue((boolean)validationMessages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_HREF_SYNTAX)));
        Assert.assertTrue((boolean)validationMessages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }
}

