/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.validation.v1_1;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDecisionTest
extends AbstractValidatorTest {
    @Test
    public void testDECISION_MISSING_EXPR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_EXPR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
        }
    }

    @Test
    public void testDECISION_MISSING_EXPR_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    public void testDECISION_MISSING_EXPR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_EXPR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    public void testDECISION_MISSING_VAR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        }
    }

    @Test
    public void testDECISION_MISSING_VAR_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VAR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VARbis_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISSING_VARbis.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        }
    }

    @Test
    public void testDECISION_MISSING_VARbis_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISSING_VARbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISSING_VARbis_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISSING_VARbis.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VARbis"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
    }

    @Test
    public void testDECISION_MISMATCH_VAR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MISMATCH_VAR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
        }
    }

    @Test
    public void testDECISION_MISMATCH_VAR_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MISMATCH_VAR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testDECISION_MISMATCH_VAR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MISMATCH_VAR.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MISSING_VAR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
    }

    @Test
    public void testDECISION_MULTIPLE_EXPRESSIONS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        }
    }

    @Test
    public void testDECISION_MULTIPLE_EXPRESSIONS_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
    }

    @Test
    public void testDECISION_MULTIPLE_EXPRESSIONS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_MULTIPLE_EXPRESSIONS.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_MULTIPLE_EXPRESSIONS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDECISION_PERF_INDICATOR_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testDECISION_PERF_INDICATOR_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_PERF_INDICATOR_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_PERF_INDICATOR_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_PERF_INDICATOR_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_MAKER_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testDECISION_DECISION_MAKER_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_MAKER_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DECISION_MAKER_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DECISION_MAKER_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_OWNER_WRONG_TYPE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testDECISION_DECISION_OWNER_WRONG_TYPE_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DECISION_OWNER_WRONG_TYPE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DECISION_OWNER_WRONG_TYPE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DECISION_MAKER_WRONG_TYPE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_CYCLIC_DEPENDENCY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_CYCLIC_DEPENDENCY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_CYCLIC_DEPENDENCY.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_CYCLIC_DEPENDENCY"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
        }
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_CYCLIC_DEPENDENCY_SELF_REFERENCE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)));
    }

    @Test
    public void testDECISION_DEADLY_DIAMOND_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DEADLY_DIAMOND.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    public void testDECISION_DEADLY_DIAMOND_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DEADLY_DIAMOND.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDECISION_DEADLY_DIAMOND_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DEADLY_DIAMOND.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DEADLY_DIAMOND"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDECISION_DEADLY_KITE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("decision/DECISION_DEADLY_KITE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        }
    }

    @Test
    public void testDECISION_DEADLY_KITE_FileInput() {
        List validate = validator.validate(this.getFile("decision/DECISION_DEADLY_KITE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDECISION_DEADLY_KITE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("decision/DECISION_DEADLY_KITE.dmn", "https://github.com/kiegroup/kie-dmn", "DECISION_DEADLY_KITE"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }
}

