/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.core.v1_1;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoPeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.event.AfterEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.AfterEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateContextEntryEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionTableEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.model.Person;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.DMNTestUtil;
import org.kie.dmn.core.util.DynamicTypeUtils;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.marshaller.FEELStringMarshaller;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.legacy.tests.core.v1_1.BaseDMN1_1VariantTest;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_1.TDecision;
import org.kie.dmn.model.v1_1.TDefinitions;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeTest
extends BaseDMN1_1VariantTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRuntimeTest.class);

    public DMNRuntimeTest(BaseVariantTest.VariantTestConf testConfig) {
        super(testConfig);
    }

    @Test
    public void testSimpleItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"simple-item-def.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn/itemdef", "simple-item-def");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)1000);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Yearly Salary")).isEqualTo((Object)new BigDecimal("12000"));
    }

    @Test
    public void testCompositeItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0008-LX-arithmetic.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0008-LX-arithmetic");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Number> loan = new HashMap<String, Number>();
        loan.put("principal", 600000);
        loan.put("rate", 0.0375);
        loan.put("termMonths", 360);
        context.set("loan", loan);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("payment")).isEqualTo((Object)new BigDecimal("2778.693549432766768088520383236299"));
    }

    @Test
    public void testTrisotechNamespace() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"trisotech_namespace.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b8feec86-dadf-4051-9feb-8e6093bbb530", "Solution 3");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("IsDoubleHulled", (Object)true);
        context.set("Residual Cargo Size", (Object)BigDecimal.valueOf(0.1));
        context.set("Ship Size", (Object)new BigDecimal(50));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Ship can enter a Dutch port")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testEmptyDecision1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"empty_decision.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ba9fc4b1-5ced-4d00-9b61-290de4bf3213", "Solution 3");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Comparable<BigDecimal>> shipInfo = new HashMap<String, Comparable<BigDecimal>>();
        shipInfo.put("Size", BigDecimal.valueOf(70L));
        shipInfo.put("Is Double Hulled", Boolean.FALSE);
        shipInfo.put("Residual Cargo Size", BigDecimal.valueOf(0.1));
        context.set("Ship Info", shipInfo);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isTrue();
        Assertions.assertThat((Object)result.get("Ship Can Enter v2")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testEmptyDecision2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"empty_decision.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ba9fc4b1-5ced-4d00-9b61-290de4bf3213", "Solution 3");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Comparable<BigDecimal>> shipInfo = new HashMap<String, Comparable<BigDecimal>>();
        shipInfo.put("Size", BigDecimal.valueOf(70L));
        shipInfo.put("Is Double Hulled", Boolean.FALSE);
        shipInfo.put("Residual Cargo Size", BigDecimal.valueOf(0.1));
        context.set("Ship Info", shipInfo);
        context.set("Ship Size", (Object)BigDecimal.valueOf(70L));
        context.set("IsDoubleHulled", (Object)Boolean.FALSE);
        context.set("Residual Cargo Size", (Object)BigDecimal.valueOf(0.1));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        List messages = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.WARN});
        Assertions.assertThat((List)messages).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(0)).getSeverity()).isEqualTo((Object)DMNMessage.Severity.WARN);
        Assertions.assertThat((String)((DMNMessage)messages.get(0)).getSourceId()).isEqualTo("_42806504-8ed5-488f-b274-de98c1bc67b9");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Ship Can Enter v2")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testEventListeners() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"car_damage_responsibility.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_820611e9-c21c-47cd-8e52-5cba2be9f9cc", "Car Damage Responsibility");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Membership Level", (Object)"Silver");
        context.set("Damage Types", (Object)"Body");
        context.set("Responsible", (Object)"Driver");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AfterEvaluateDecisionTableEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).beforeEvaluateDecision((BeforeEvaluateDecisionEvent)ArgumentMatchers.any(BeforeEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecision((AfterEvaluateDecisionEvent)ArgumentMatchers.any(AfterEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).beforeEvaluateDecisionTable((BeforeEvaluateDecisionTableEvent)ArgumentMatchers.any(BeforeEvaluateDecisionTableEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)2))).afterEvaluateDecisionTable((AfterEvaluateDecisionTableEvent)argument.capture());
        AfterEvaluateDecisionTableEvent dte = (AfterEvaluateDecisionTableEvent)argument.getAllValues().get(0);
        Assertions.assertThat((String)dte.getDecisionTableName()).isEqualTo("Car Damage Responsibility");
        Assertions.assertThat((List)dte.getMatches()).containsExactly((Object[])new Integer[]{5});
        dte = (AfterEvaluateDecisionTableEvent)argument.getAllValues().get(1);
        Assertions.assertThat((String)dte.getDecisionTableName()).isEqualTo("Payment method");
        Assertions.assertThat((List)dte.getMatches()).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Map)((Map)result.get("Car Damage Responsibility"))).containsEntry((Object)"EU Rent", (Object)BigDecimal.valueOf(40L));
        Assertions.assertThat((Map)((Map)result.get("Car Damage Responsibility"))).containsEntry((Object)"Renter", (Object)BigDecimal.valueOf(60L));
        Assertions.assertThat((Object)result.get("Payment method")).isEqualTo((Object)"Check");
    }

    @Test
    public void testContextEventListeners() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"context_listener.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeEventListener listener = (DMNRuntimeEventListener)Mockito.mock(DMNRuntimeEventListener.class);
        runtime.addListener(listener);
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_73481d02-76fb-4927-ac11-5d936882e16c", "context listener");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ArgumentCaptor argument = ArgumentCaptor.forClass(AfterEvaluateContextEntryEvent.class);
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)1))).beforeEvaluateDecision((BeforeEvaluateDecisionEvent)ArgumentMatchers.any(BeforeEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)1))).afterEvaluateDecision((AfterEvaluateDecisionEvent)ArgumentMatchers.any(AfterEvaluateDecisionEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)5))).beforeEvaluateContextEntry((BeforeEvaluateContextEntryEvent)ArgumentMatchers.any(BeforeEvaluateContextEntryEvent.class));
        ((DMNRuntimeEventListener)Mockito.verify((Object)listener, (VerificationMode)VerificationModeFactory.times((int)5))).afterEvaluateContextEntry((AfterEvaluateContextEntryEvent)argument.capture());
        AfterEvaluateContextEntryEvent aece = (AfterEvaluateContextEntryEvent)argument.getAllValues().get(0);
        Assertions.assertThat((String)aece.getNodeName()).isEqualTo("d1");
        Assertions.assertThat((String)aece.getVariableName()).isEqualTo("a1");
        Assertions.assertThat((String)aece.getVariableId()).isEqualTo("_b199c7b1-cb87-4a92-b045-a2954ccc9d01");
        Assertions.assertThat((String)aece.getExpressionId()).isEqualTo("_898c24f8-93da-4fe2-827c-924c30956833");
        Assertions.assertThat((Object)aece.getExpressionResult()).isEqualTo((Object)BigDecimal.valueOf(10L));
        aece = (AfterEvaluateContextEntryEvent)argument.getAllValues().get(1);
        Assertions.assertThat((String)aece.getNodeName()).isEqualTo("d1");
        Assertions.assertThat((String)aece.getVariableName()).isEqualTo("c1");
        Assertions.assertThat((String)aece.getVariableId()).isEqualTo("_38a88aef-8b3c-424d-b60c-a139ffb610e1");
        Assertions.assertThat((String)aece.getExpressionId()).isEqualTo("_879c4ac6-8b25-4cd1-9b8e-c18d0b0b281c");
        Assertions.assertThat((Object)aece.getExpressionResult()).isEqualTo((Object)"a");
        aece = (AfterEvaluateContextEntryEvent)argument.getAllValues().get(2);
        Assertions.assertThat((String)aece.getNodeName()).isEqualTo("d1");
        Assertions.assertThat((String)aece.getVariableName()).isEqualTo("c2");
        Assertions.assertThat((String)aece.getVariableId()).isEqualTo("_3aad82f0-74b9-4921-8b2f-d6c277c840db");
        Assertions.assertThat((String)aece.getExpressionId()).isEqualTo("_9acf4baf-6c49-4d47-88ab-2e511e598e04");
        Assertions.assertThat((Object)aece.getExpressionResult()).isEqualTo((Object)"b");
        aece = (AfterEvaluateContextEntryEvent)argument.getAllValues().get(3);
        Assertions.assertThat((String)aece.getNodeName()).isEqualTo("d1");
        Assertions.assertThat((String)aece.getVariableName()).isEqualTo("b1");
        Assertions.assertThat((String)aece.getVariableId()).isEqualTo("_f4a6c2ba-e6e9-4dbd-b776-edef2c1a1343");
        Assertions.assertThat((String)aece.getExpressionId()).isEqualTo("_c450d947-1874-41fe-9c0a-da5f1cca7fde");
        Assertions.assertThat((Map)((Map)aece.getExpressionResult())).containsEntry((Object)"c1", (Object)"a");
        Assertions.assertThat((Map)((Map)aece.getExpressionResult())).containsEntry((Object)"c2", (Object)"b");
        aece = (AfterEvaluateContextEntryEvent)argument.getAllValues().get(4);
        Assertions.assertThat((String)aece.getNodeName()).isEqualTo("d1");
        Assertions.assertThat((String)aece.getVariableName()).isEqualTo("__RESULT__");
        Assertions.assertThat((String)aece.getVariableId()).isNull();
        Assertions.assertThat((String)aece.getExpressionId()).isEqualTo("_4264b25c-d676-4516-ab8a-a4ff34e7a95c");
        Assertions.assertThat((Object)aece.getExpressionResult()).isEqualTo((Object)"a");
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("d1")).isEqualTo((Object)"a");
    }

    @Test
    public void testErrorMessages() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"car_damage_responsibility2.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((List)messages).isNotEmpty();
    }

    @Test
    public void testOutputReuse() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Input_reuse_in_output.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_098bb607-eff7-4772-83ac-6ded8b371fa7", "Input reuse in output");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Age", (Object)40);
        context.set("Requested Product", (Object)"Fixed30");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("My Decision")).isEqualTo((Object)"Fixed30");
    }

    @Test
    public void testSimpleNot() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Simple_Not.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_98436ebb-7c42-48c0-8d11-d693e2a817c9", "Simple Not");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Occupation", (Object)"Student");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a")).isEqualTo((Object)"Is Student");
    }

    @Test
    public void testSimpleNot2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Simple_Not.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_98436ebb-7c42-48c0-8d11-d693e2a817c9", "Simple Not");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Occupation", (Object)"Engineer");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("a")).isEqualTo((Object)"Is not a Student");
    }

    @Test
    public void testDinner() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Dinner.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_0c45df24-0d57-4acc-b296-b4cba8b71a36", "Dinner");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assertions.assertThat((boolean)dmnModel.hasErrors()).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Guests with children", (Object)true);
        context.set("Season", (Object)"Fall");
        context.set("Number of guests", (Object)4);
        context.set("Temp", (Object)25);
        context.set("Rain Probability", (Object)30);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getContext().get("Where to eat")).isEqualTo((Object)"Outside");
        Assertions.assertThat((Object)dmnResult.getContext().get("Dish")).isEqualTo((Object)"Spareribs");
        Assertions.assertThat((Object)dmnResult.getContext().get("Drinks")).asList().containsExactly(new Object[]{"Apero", "Ale", "Juice Boxes"});
    }

    @Test
    public void testNotificationsApproved2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"NotificationsTest2.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "building-structure-rules");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("existingActivityApplicability", (Object)true);
        context.set("Distance", (Object)new BigDecimal(9999));
        context.set("willIncreaseTraffic", (Object)true);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Notification Status")).isEqualTo((Object)"Notification to Province Approved");
        Assertions.assertThat((Object)result.get("Permit Status")).isEqualTo((Object)"Building Activity Province Permit Required");
    }

    @Test
    public void testBoxedContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"BoxedContext.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_0de36357-fec0-4b4e-b7f1-382d381e06e9", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Map)((Map)dmnResult.getContext().get("Math"))).containsEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L));
        Assertions.assertThat((Map)((Map)dmnResult.getContext().get("Math"))).containsEntry((Object)"Product", (Object)BigDecimal.valueOf(50L));
    }

    @Test
    public void testFunctionDefAndInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"FunctionDefinition.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_0de36357-fec0-4b4e-b7f1-382d381e06e9", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Map)((Map)dmnResult.getContext().get("Math"))).containsEntry((Object)"Sum", (Object)BigDecimal.valueOf(15L));
    }

    @Test
    public void testBuiltInFunctionInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"BuiltInFunctionInvocation.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b77219ee-ec28-48e3-b240-8e0dbbabefeb", "built in function invocation");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a", (Object)10);
        context.set("b", (Object)5);
        context.set("x", (Object)"Hello, World!");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getContext().get("calc min")).isEqualTo((Object)BigDecimal.valueOf(5L));
        Assertions.assertThat((Object)dmnResult.getContext().get("fixed params")).isEqualTo((Object)"World!");
        Assertions.assertThat((Object)dmnResult.getContext().get("out of order")).isEqualTo((Object)BigDecimal.valueOf(5L));
    }

    @Test
    public void testBKMNode() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0009-invocation-arithmetic.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_cb28c255-91cd-4c01-ac7b-1a9cb1ecdb11", "literal invocation1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        HashMap<String, BigDecimal> loan = new HashMap<String, BigDecimal>();
        loan.put("amount", BigDecimal.valueOf(600000L));
        loan.put("rate", new BigDecimal("0.0375"));
        loan.put("term", BigDecimal.valueOf(360L));
        DMNContext context = DMNFactory.newContext();
        context.set("fee", (Object)100);
        context.set("Loan", loan);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((BigDecimal)((BigDecimal)dmnResult.getContext().get("MonthlyPayment")).setScale(8, 1)).isEqualTo((Object)new BigDecimal("2878.69354943277").setScale(8, 1));
    }

    @Test
    public void testItemDefCollection() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-filter.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_f52ca843-504b-4c3b-a6bc-4d377bffef7a", "filter01");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        Object[][] data = new Object[][]{{1, "Finances", "John"}, {2, "Engineering", "Mary"}, {3, "Sales", "Kevin"}};
        ArrayList employees = new ArrayList();
        for (Object[] aData : data) {
            HashMap<String, Object> e = new HashMap<String, Object>();
            e.put("id", aData[0]);
            e.put("dept", aData[1]);
            e.put("name", aData[2]);
            employees.add(e);
        }
        DMNContext context = DMNFactory.newContext();
        context.set("Employee", employees);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getContext().get("filter01")).asList().containsExactly(new Object[]{"Mary"});
    }

    @Test
    public void testList() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"list-expression.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "list-expression");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getContext().get("Name list")).asList().containsExactly(new Object[]{"John", "Mary"});
    }

    @Test
    public void testRelation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"relation-expression.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "relation-expression");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getContext().get("Employee Relation")).isInstanceOf(List.class);
        List employees = (List)dmnResult.getContext().get("Employee Relation");
        Map e = (Map)employees.get(0);
        Assertions.assertThat(e.get("Name")).isEqualTo((Object)"John");
        Assertions.assertThat(e.get("Dept")).isEqualTo((Object)"Sales");
        Assertions.assertThat(e.get("Salary")).isEqualTo((Object)BigDecimal.valueOf(100000L));
        e = (Map)employees.get(1);
        Assertions.assertThat(e.get("Name")).isEqualTo((Object)"Mary");
        Assertions.assertThat(e.get("Dept")).isEqualTo((Object)"Finances");
        Assertions.assertThat(e.get("Salary")).isEqualTo((Object)BigDecimal.valueOf(120000L));
    }

    @Test
    public void testLendingExample() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0004-lending.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_4e0f0b70-d31c-471c-bd52-5ca709ed362b", "Lending1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        HashMap<String, Object> applicant = new HashMap<String, Object>();
        HashMap<String, Integer> monthly = new HashMap<String, Integer>();
        monthly.put("Income", 6000);
        monthly.put("Expenses", 2000);
        monthly.put("Repayments", 0);
        applicant.put("Monthly", monthly);
        applicant.put("Age", 35);
        applicant.put("ExistingCustomer", true);
        applicant.put("MaritalStatus", "M");
        applicant.put("EmploymentStatus", "EMPLOYED");
        HashMap<String, Object> product = new HashMap<String, Object>();
        product.put("ProductType", "STANDARD LOAN");
        product.put("Amount", 350000);
        product.put("Rate", new BigDecimal("0.0395"));
        product.put("Term", 360);
        HashMap<String, Constable> bureau = new HashMap<String, Constable>();
        bureau.put("CreditScore", Integer.valueOf(649));
        bureau.put("Bankrupt", Boolean.valueOf(false));
        context.set("ApplicantData", applicant);
        context.set("RequestedProduct", product);
        context.set("BureauData", bureau);
        context.set("SupportingDocuments", (Object)"yes");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        DMNContext ctx = dmnResult.getContext();
        Assertions.assertThat((Object)ctx.get("ApplicationRiskScore")).isEqualTo((Object)BigDecimal.valueOf(130L));
        Assertions.assertThat((Object)ctx.get("Pre-bureauRiskCategory")).isEqualTo((Object)"LOW");
        Assertions.assertThat((Object)ctx.get("BureauCallType")).isEqualTo((Object)"MINI");
        Assertions.assertThat((Object)ctx.get("Post-bureauRiskCategory")).isEqualTo((Object)"LOW");
        Assertions.assertThat((BigDecimal)((BigDecimal)ctx.get("RequiredMonthlyInstallment")).setScale(5, 1)).isEqualTo((Object)new BigDecimal("1680.880325608555").setScale(5, 1));
        Assertions.assertThat((Object)ctx.get("Pre-bureauAffordability")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)ctx.get("Eligibility")).isEqualTo((Object)"ELIGIBLE");
        Assertions.assertThat((Object)ctx.get("Strategy")).isEqualTo((Object)"BUREAU");
        Assertions.assertThat((Object)ctx.get("Post-bureauAffordability")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)ctx.get("Routing")).isEqualTo((Object)"ACCEPT");
    }

    @Test
    public void testDateAndTime() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0007-date-time.dmn", ((Object)((Object)this)).getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_69430b3e-17b8-430d-b760-c505bf6469f9", "dateTime Table 58");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("dateString", (Object)"2015-12-24");
        context.set("timeString", (Object)"00:00:01-01:00");
        context.set("dateTimeString", (Object)"2016-12-24T23:59:00-05:00");
        context.set("Hours", (Object)12);
        context.set("Minutes", (Object)59);
        context.set("Seconds", (Object)new BigDecimal("1.3"));
        context.set("Timezone", (Object)"PT-1H");
        context.set("Year", (Object)1999);
        context.set("Month", (Object)11);
        context.set("Day", (Object)22);
        context.set("oneHour", (Object)Duration.parse("PT1H"));
        context.set("durationString", (Object)"P13DT2H14S");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext ctx = dmnResult.getContext();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)ctx.get("Date-Time")).isEqualTo((Object)ZonedDateTime.of(2016, 12, 24, 23, 59, 0, 0, ZoneOffset.ofHours(-5)));
        Assertions.assertThat((Object)ctx.get("Date")).isEqualTo((Object)new HashMap<String, Object>(){
            {
                this.put("fromString", LocalDate.of(2015, 12, 24));
                this.put("fromDateTime", LocalDate.of(2016, 12, 24));
                this.put("fromYearMonthDay", LocalDate.of(1999, 11, 22));
            }
        });
        Assertions.assertThat((Object)ctx.get("Time")).isEqualTo((Object)OffsetTime.of(0, 0, 1, 0, ZoneOffset.ofHours(-1)));
        Assertions.assertThat((Object)ctx.get("Date-Time2")).isEqualTo((Object)ZonedDateTime.of(2015, 12, 24, 0, 0, 1, 0, ZoneOffset.ofHours(-1)));
        Assertions.assertThat((Object)ctx.get("Time2")).isEqualTo((Object)OffsetTime.of(0, 0, 1, 0, ZoneOffset.ofHours(-1)));
        Assertions.assertThat((Object)ctx.get("Time3")).isEqualTo((Object)OffsetTime.of(12, 59, 1, 300000000, ZoneOffset.ofHours(-1)));
        Assertions.assertThat((Object)ctx.get("dtDuration1")).isEqualTo((Object)Duration.parse("P13DT2H14S"));
        Assertions.assertThat((Object)ctx.get("dtDuration2")).isEqualTo((Object)Duration.parse("P367DT3H58M59S"));
        Assertions.assertThat((Object)ctx.get("hoursInDuration")).isEqualTo((Object)new BigDecimal("3"));
        Assertions.assertThat((Object)ctx.get("sumDurations")).isEqualTo((Object)Duration.parse("PT9125H59M13S"));
        Assertions.assertThat((Object)ctx.get("ymDuration2")).isEqualTo((Object)ComparablePeriod.parse((CharSequence)"P1Y"));
        Assertions.assertThat((Object)ctx.get("cDay")).isEqualTo((Object)BigDecimal.valueOf(24L));
        Assertions.assertThat((Object)ctx.get("cYear")).isEqualTo((Object)BigDecimal.valueOf(2015L));
        Assertions.assertThat((Object)ctx.get("cMonth")).isEqualTo((Object)BigDecimal.valueOf(12L));
        Assertions.assertThat((Object)ctx.get("cHour")).isEqualTo((Object)BigDecimal.valueOf(0L));
        Assertions.assertThat((Object)ctx.get("cMinute")).isEqualTo((Object)BigDecimal.valueOf(0L));
        Assertions.assertThat((Object)ctx.get("cSecond")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)ctx.get("cTimezone")).isEqualTo((Object)"GMT-01:00");
        Assertions.assertThat((Object)ctx.get("years")).isEqualTo((Object)BigDecimal.valueOf(1L));
        Assertions.assertThat((Object)ctx.get("d1seconds")).isEqualTo((Object)BigDecimal.valueOf(14L));
    }

    @Test
    public void testFiltering() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Person_filtering_by_age.dmn", ((Object)((Object)this)).getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_e215ed7a-701b-4c53-b8df-4b4d23d5fe32", "Person filtering by age");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Min Age", (Object)50);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)((List)dmnResult.getContext().get("Filtering"))).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0]).hasSize(2);
    }

    @Test
    public void testNowFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"today_function_test.dmn", ((Object)((Object)this)).getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_4ad80959-5fd8-46b7-8c9a-ab2fa58cb5b4", "When is it");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("The date", (Object)LocalDate.of(2017, 1, 12));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((ObjectAssert)Assertions.assertThat((Object)dmnResult.getContext().get("When is it")).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isEqualTo((Object)"It is in the past");
    }

    @Test
    public void testTimeFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"TimeFromDate.dmn", ((Object)((Object)this)).getClass());
        runtime.addListener(DMNRuntimeUtil.createListener());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_ecf4ea54-2abc-4e2f-a101-4fe14e356a46", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("datetimestring", (Object)"2016-07-29T05:48:23");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((ObjectAssert)Assertions.assertThat((Object)dmnResult.getContext().get("time")).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isEqualTo((Object)LocalTime.of(5, 48, 23));
    }

    @Test
    public void testAlternativeNSDecl() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"alternative_feel_ns_declaration.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult()).isEqualTo((Object)"Hello John Doe");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Greeting Message")).isEqualTo((Object)"Hello John Doe");
    }

    @Test
    public void testLoanComparison() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"loanComparison.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3a1fd8f4-ea04-4453-aa30-ff14140e3441", "loanComparison");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("RequestedAmt", (Object)500000);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testGetViableLoanProducts() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Get_Viable_Loan_Products.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3e1a628d-36bc-45f1-8464-b201735e5ce0", "Get Viable Loan Products");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        HashMap<String, Object> requested = new HashMap<String, Object>();
        requested.put("PropertyZIP", "91001");
        requested.put("LoanAmt", 300000);
        requested.put("Objective", "Payment");
        requested.put("DownPct", new BigDecimal("0.4"));
        requested.put("MortgageType", "Fixed 20");
        DMNContext context = DMNFactory.newContext();
        context.set("Requested", requested);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("isConforming")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Iterable)((Collection)result.get("LoanTypes"))).hasSize(3);
    }

    @Test
    public void testYearsAndMonthsDuration() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"yearMonthDuration.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_6eda1490-21ca-441e-8a26-ab3ca800e43c", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        BuiltInType feelType = (BuiltInType)BuiltInType.determineTypeFromName((String)"yearMonthDuration");
        ChronoPeriod period = (ChronoPeriod)feelType.fromString("P2Y1M");
        DMNContext context = runtime.newContext();
        context.set("iDuration", (Object)period);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("How long")).isEqualTo((Object)"Longer than a year");
    }

    @Test
    public void testInvalidVariableNames() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"invalid-variable-names.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((List)messages).isNotEmpty();
    }

    @Test
    public void testNull() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"null_values.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "Null values model");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("Null Input", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Null value")).isEqualTo((Object)"Input is null");
        context = runtime.newContext();
        context.set("Null Input", (Object)"foo");
        dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Null value")).isEqualTo((Object)"Input is not null");
    }

    @Test
    public void testInvalidModel() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"Loan_Prequalification_Condensed_Invalid.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((List)messages).hasSize(2);
        Assertions.assertThat((String)((DMNMessage)messages.get(0)).getSourceId()).isEqualTo("_8b5cac9e-c8ca-4817-b05a-c70fa79a8d48");
        Assertions.assertThat((String)((DMNMessage)messages.get(1)).getSourceId()).isEqualTo("_ef09d90e-e1a4-4ec9-885b-482d1f4a1cee");
    }

    @Test
    public void testNullOnNumber() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Number_and_null_entry.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_a293b9f9-c912-41ee-8147-eae59ba86ac5", "Number and null entry");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("num", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decision Logic 1")).isEqualTo((Object)"Null");
        context = runtime.newContext();
        context.set("num", (Object)4);
        dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decision Logic 1")).isEqualTo((Object)"Positive number");
    }

    @Test
    public void testLoan_Recommendation2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Loan_Recommendation2.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_35c7339b-b868-43da-8f06-eb481708c73c", "Loan Recommendation2");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        HashMap<String, Number> loan = new HashMap<String, Number>();
        loan.put("Amount", 100000);
        loan.put("Rate", 2.39);
        loan.put("Term", 60);
        HashMap<String, Object> borrower = new HashMap<String, Object>();
        borrower.put("Age", 39);
        borrower.put("EmploymentStatus", "Employed");
        borrower.put("YearsAtCurrentEmployer", 10);
        borrower.put("TotalAnnualIncome", 150000);
        borrower.put("NonSalaryIncome", 0);
        borrower.put("MonthlyDebtPmtAmt", 2000);
        borrower.put("LiquidAssetsAmt", 50000);
        DMNContext context = runtime.newContext();
        context.set("Credit Score", null);
        context.set("Appraised Value", (Object)200000);
        context.set("Loan", loan);
        context.set("Borrower", borrower);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Loan Recommendation")).isEqualTo((Object)"Decline");
    }

    @Test
    public void testPriority_table() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"priority_table.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ff54a44d-b8f5-48fc-b2b7-43db767e8a1c", "not quite all or nothing P");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("isAffordable", (Object)false);
        context.set("RiskCategory", (Object)"Medium");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Declined");
    }

    @Test
    public void testPriority_table_context_recursion() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"priority_table_context_recursion.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ff54a44d-b8f5-48fc-b2b7-43db767e8a1c", "not quite all or nothing P");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("isAffordable", (Object)false);
        context.set("RiskCategory", (Object)"Medium");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Approval Status")).isEqualTo((Object)"Declined");
    }

    @Test
    public void testPriority_table_missing_output_values() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"DTABLE_PRIORITY_MISSING_OUTVALS.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((List)messages).hasSize(1);
    }

    @Test
    public void test_non_Priority_table_missing_output_values() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DTABLE_NON_PRIORITY_MISSING_OUTVALS.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "DTABLE_NON_PRIORITY_MISSING_OUTVALS");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testPriority_table_one_output_value() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DTABLE_PRIORITY_ONE_OUTVAL.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_ONE_OUTVAL");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testNoPrefix() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"drools1502-noprefix.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        context.set("MyInput", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("MyDecision")).isEqualTo((Object)"Decision taken");
    }

    @Test
    public void testWrongConstraintsInItemDefinition() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"WrongConstraintsInItemDefinition.dmn", ((Object)((Object)this)).getClass());
        ((ListAssert)Assertions.assertThat((List)messages).as(DMNRuntimeUtil.formatMessages((List)messages), new Object[0])).hasSize(3);
        Assertions.assertThat((Object)((DMNMessage)messages.get(0)).getSourceReference()).isInstanceOf(ItemDefinition.class);
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(0)).getMessageType()).isEqualTo((Object)DMNMessageType.ERR_COMPILING_FEEL);
        Assertions.assertThat((String)((DMNMessage)messages.get(1)).getSourceId()).isEqualTo("_e794c655-4fdf-45d1-b7b7-d990df513f92");
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(1)).getMessageType()).isEqualTo((Object)DMNMessageType.ERR_COMPILING_FEEL);
        Assertions.assertThat((String)((DMNMessage)messages.get(2)).getSourceId()).isEqualTo("_31911de7-e184-411c-99d1-f33977971270");
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(2)).getMessageType()).isEqualTo((Object)DMNMessageType.MISSING_TYPE_REF);
    }

    @Test
    public void testResolutionOfVariableWithLeadingOrTrailingSpaces() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"variableLeadingTrailingSpaces.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://www.drools.org/kie-dmn/definitions", "definitions");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("Name", "John");
        person.put("Surname", "Doe");
        context.set("Input Person", person);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Further Decision")).isEqualTo((Object)"The person was greeted with: 'Ciao John Doe'");
    }

    @Test
    public void testOutOfOrderItemsNPE() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"out-of-order-items.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn", "out-of-order");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.FAILED_VALIDATOR))).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testItemDefDependencies() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"itemDef-dependency.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_2374ee6d-75ed-4e9d-95d3-a88c135e1c43", "Drawing 1a");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("Full Name", "John Doe");
        person.put("Address", "100 East Davie Street");
        context.set("Input Person", person);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("My Decision")).isEqualTo((Object)"The person John Doe is located at 100 East Davie Street");
    }

    @Test
    public void testDecisionResultTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"LoanRecommendationWrongOutputType.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_591d49d0-26e1-4a1c-9f72-b65bec09964a", "Loan Recommendation Multi-step");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        System.out.println(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        HashMap<String, Integer> loan = new HashMap<String, Integer>();
        loan.put("Amount", 100);
        loan.put("Rate", 12);
        loan.put("Term", 1);
        context.set("Loan", loan);
        DMNResult dmnResult = runtime.evaluateByName(dmnModel, context, new String[]{"Loan Payment"});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((List)dmnResult.getMessages()).hasSize(1);
        Assertions.assertThat((String)((DMNMessage)dmnResult.getMessages().get(0)).getSourceId()).isEqualTo("_93062144-ebc7-4ef7-a156-c342aeffac49");
        Assertions.assertThat((Comparable)((DMNMessage)dmnResult.getMessages().get(0)).getMessageType()).isEqualTo((Object)DMNMessageType.ERROR_EVAL_NODE);
    }

    @Test
    public void testNPE() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"NPE.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_95b7ee22-1964-4be5-b7db-7db66692c707", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testUnionofLetters() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Union_of_letters.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_76362694-41e8-400c-8dea-e5f033d4f405", "Union of letters");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx1 = runtime.newContext();
        ctx1.set("A1", Arrays.asList("a", "b"));
        ctx1.set("A2", Arrays.asList("b", "c"));
        DMNResult dmnResult1 = runtime.evaluateAll(dmnModel, ctx1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult1.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult1.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((List)((List)dmnResult1.getContext().get("D1"))).asList().contains(new Object[]{"a", "b", "c"});
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("A1", Arrays.asList("a", "b"));
        ctx2.set("A2", Arrays.asList("b", "x"));
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult2.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult2.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult2.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.ERROR_EVAL_NODE))).isTrue();
    }

    @Test
    public void testUnknownVariable1() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"unknown_variable1.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((long)messages.stream().filter(m -> m.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)).filter(m -> m.getMessage().contains("Unknown variable 'NonSalaryPct'")).count()).isEqualTo(1L);
    }

    @Test
    public void testUnknownVariable2() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"unknown_variable2.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((Comparable)((DMNMessage)messages.get(0)).getMessageType()).isEqualTo((Object)DMNMessageType.ERR_COMPILING_FEEL);
        Assertions.assertThat((String)((DMNMessage)messages.get(0)).getMessage()).containsSequence(new CharSequence[]{"Unknown variable 'Borrower.liquidAssetsAmt'"});
    }

    @Test
    public void testSingleDecisionWithContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"SingleDecisionWithContext.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_71af58db-e1df-4b0f-aee2-48e0e8d89672", "SingleDecisionWithContext");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("MyDecision")).isEqualTo((Object)"Hello John Doe");
    }

    @Test
    public void testEx_6_1() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Ex_6_1.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5f1269c8-1e6f-4748-9eca-26aa1b1278ef", "Ex 6-1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        HashMap<String, Object> t1 = new HashMap<String, Object>();
        t1.put("city", "Los Angeles");
        t1.put("name", "Los Angeles");
        t1.put("wins", 0);
        t1.put("losses", 1);
        t1.put("bonus points", 40);
        HashMap<String, Object> t2 = new HashMap<String, Object>();
        t2.put("city", "San Francisco");
        t2.put("name", "San Francisco");
        t2.put("wins", 1);
        t2.put("losses", 0);
        t2.put("bonus points", 7);
        ctx.set("NBA Pacific", Arrays.asList(t1, t2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Number of distinct cities")).isEqualTo((Object)new BigDecimal(2));
        Assertions.assertThat((Object)result.get("Second place losses")).isEqualTo((Object)new BigDecimal(0));
        Assertions.assertThat((Object)result.get("Max wins")).isEqualTo((Object)new BigDecimal(1));
        Assertions.assertThat((Object)result.get("Mean wins")).isEqualTo((Object)new BigDecimal(0.5));
        Assertions.assertThat((List)((List)result.get("Positions of Los Angeles teams"))).asList().contains(new Object[]{new BigDecimal(1)});
        Assertions.assertThat((Object)result.get("Number of teams")).isEqualTo((Object)new BigDecimal(2));
        Assertions.assertThat((Object)result.get("Sum of bonus points")).isEqualTo((Object)new BigDecimal(47));
    }

    @Test
    public void testSingletonlist_function_call() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"singletonlist_fuction_call.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_0768879b-5ee1-410f-92f0-7732573b069d", "expression function subst [a] with a");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        ctx.set("InputLineItem", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0015"), DynamicTypeUtils.entry((Object)"Description", (Object)"additional Battery")}));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("The Battery")).isEqualTo((Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0010"), DynamicTypeUtils.entry((Object)"Description", (Object)"Battery")}));
        Assertions.assertThat((List)((List)result.get("Remove Battery"))).asList().contains(new Object[]{DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0020"), DynamicTypeUtils.entry((Object)"Description", (Object)"Case")}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0030"), DynamicTypeUtils.entry((Object)"Description", (Object)"Power Supply")})});
        Assertions.assertThat((List)((List)result.get("Remove Battery"))).asList().doesNotContain(new Object[]{DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0010"), DynamicTypeUtils.entry((Object)"Description", (Object)"Battery")})});
        Assertions.assertThat((List)((List)result.get("Insert before Line 0020"))).asList().contains(new Object[]{DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0010"), DynamicTypeUtils.entry((Object)"Description", (Object)"Battery")}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0015"), DynamicTypeUtils.entry((Object)"Description", (Object)"additional Battery")}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0020"), DynamicTypeUtils.entry((Object)"Description", (Object)"Case")}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Line", (Object)"0030"), DynamicTypeUtils.entry((Object)"Description", (Object)"Power Supply")})});
    }

    @Test
    public void testJavaFunctionContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"java_function_context.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b42317c4-4f0c-474e-a0bf-2895b0b3c314", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        ctx.set("Input", (Object)3.14);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((BigDecimal)((BigDecimal)result.get("D1")).setScale(4, 4)).isEqualTo((Object)new BigDecimal("-1.0000"));
        Assertions.assertThat((BigDecimal)((BigDecimal)result.get("D2")).setScale(4, 4)).isEqualTo((Object)new BigDecimal("-1.0000"));
    }

    @Test
    public void testJavaFunctionContext_withErrors() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"java_function_context_with_errors.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((List)messages).hasSize(1);
        List sourceIDs = messages.stream().map(DMNMessage::getSourceId).collect(Collectors.toList());
        Assertions.assertThat(sourceIDs).contains((Object[])new String[]{"_a72a7aff-48c3-4806-83ca-fc1f1fe34321"});
    }

    @Test
    public void test_countCSATradeRatings() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"countCSATradeRatings.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_1a7d184c-2e38-4462-ae28-15591ef6d534", "countCSATradeRatings");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        ArrayList<Map> ratings = new ArrayList<Map>();
        ratings.add(DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Agency", (Object)"FITCH"), DynamicTypeUtils.entry((Object)"Value", (Object)"val1")}));
        ratings.add(DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Agency", (Object)"MOODY"), DynamicTypeUtils.entry((Object)"Value", (Object)"val2")}));
        ctx.set("CSA Trade Ratings", ratings);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Trade Ratings")).isEqualTo((Object)new BigDecimal(2));
        DMNContext ctx2 = runtime.newContext();
        ctx2.set("CSA Trade Ratings", null);
        DMNResult dmnResult2 = runtime.evaluateAll(dmnModel, ctx2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult2.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult2.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult2.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.FEEL_EVALUATION_ERROR))).isTrue();
        Assertions.assertThat((Comparable)dmnResult2.getDecisionResultByName("Trade Ratings").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.FAILED);
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, runtime.newContext());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult3.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult3.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult3.getMessages().stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).isTrue();
    }

    @Test
    public void testForLoopTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"PersonListHelloBKM.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ec5a78c7-a317-4c39-8310-db59be60f1c8", "PersonListHelloBKM");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        Map p1 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"John Doe"), DynamicTypeUtils.entry((Object)"Age", (Object)33)});
        Map p2 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"47"), DynamicTypeUtils.entry((Object)"Age", (Object)47)});
        context.set("My Input Data", Arrays.asList(p1, p2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((List)((List)result.get("My Decision"))).asList().contains(new Object[]{"The person named John Doe is 33 years old.", "The person named 47 is 47 years old."});
    }

    @Test
    public void testTypeInferenceForNestedContextAnonymousEntry() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"PersonListHelloBKM2.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_7e41a76e-2df6-4899-bf81-ae098757a3b6", "PersonListHelloBKM2");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = runtime.newContext();
        Map p1 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"John Doe"), DynamicTypeUtils.entry((Object)"Age", (Object)33)});
        Map p2 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"47"), DynamicTypeUtils.entry((Object)"Age", (Object)47)});
        context.set("My Input Data", Arrays.asList(p1, p2));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        DMNContext result = dmnResult.getContext();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((List)((List)result.get("My Decision"))).asList().contains(new Object[]{DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"Prof. John Doe"), DynamicTypeUtils.entry((Object)"Age", (Object)EvalHelper.coerceNumber((Object)33))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Full Name", (Object)"Prof. 47"), DynamicTypeUtils.entry((Object)"Age", (Object)EvalHelper.coerceNumber((Object)47))})});
    }

    @Test
    public void testSameEveryTypeCheck() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"same_every_type_check.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_09a13244-114d-43fb-9e00-cda89a2000dd", "same every type check");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        DMNContext result = dmnResult.getContext();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)result.get("Some are even")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Every are even")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)result.get("Some are positive")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Every are positive")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Some are negative")).isEqualTo((Object)Boolean.FALSE);
        Assertions.assertThat((Object)result.get("Every are negative")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test
    public void testDateAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"date_allowed_values.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_fbf002a3-615b-4f02-98e4-c28d4676225a", "Error with constraints verification");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext ctx = runtime.newContext();
        Object duration = BuiltInType.DURATION.fromString("P20Y");
        ctx.set("yearsMonth", duration);
        Object dateTime = BuiltInType.DATE_TIME.fromString("2017-05-16T17:58:00.000");
        ctx.set("dateTime", dateTime);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, ctx);
        DMNContext result = dmnResult.getContext();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Map)((Map)result.get("Decision Logic 1"))).containsEntry((Object)"years and months", duration);
        Assertions.assertThat((Map)((Map)result.get("Decision Logic 1"))).containsEntry((Object)"Date Time", dateTime);
    }

    @Test
    public void testArtificialAttributes() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string-artificial-attributes.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools", "0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Full Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assertions.assertThat((List)dmnResult.getDecisionResults()).hasSize(1);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult()).isEqualTo((Object)"Hello John Doe");
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Greeting Message")).isEqualTo((Object)"Hello John Doe");
    }

    @Test
    public void testInvokeFunctionSuccess() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Caller.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Calling.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("My Name", (Object)"John Doe");
        context.set("My Number", (Object)3);
        context.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        context.set("Call name", (Object)"Calling");
        context.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Final decision")).isEqualTo((Object)"The final decision is: Hello, John Doe your number once double is equal to: 6");
    }

    @Test
    public void testInvokeFunctionWrongNamespace() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Caller.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Calling.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)3);
        wrongContext.set("Call ns", (Object)"http://www.acme.com/a-wrong-namespace");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        ((ListAssert)Assertions.assertThat((List)dmnResult.getMessages()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).hasSize(2);
    }

    @Test
    public void testInvokeFunctionWrongDecisionName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Caller.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Calling.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)3);
        wrongContext.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"<unexistent decision>");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        ((ListAssert)Assertions.assertThat((List)dmnResult.getMessages()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).hasSize(2);
    }

    @Test
    public void testInvokeFunctionCallerError() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"Caller.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"Calling.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b0a696d6-3d57-4e97-b5d4-b44a63909d67", "Caller");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNContext wrongContext = DMNFactory.newContext();
        wrongContext.set("My Name", (Object)"John Doe");
        wrongContext.set("My Number", (Object)"<not a number>");
        wrongContext.set("Call ns", (Object)"http://www.trisotech.com/definitions/_88156d21-3acc-43b6-8b81-385caf0bb6ca");
        wrongContext.set("Call name", (Object)"Calling");
        wrongContext.set("Invoke decision", (Object)"Final Result");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, wrongContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        ((ListAssert)Assertions.assertThat((List)dmnResult.getMessages()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).hasSize(2);
    }

    @Test
    public void testInvalidFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"InvalidFunction.dmn", ((Object)((Object)this)).getClass(), (String[])new String[0]);
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_84453b71-5d23-479f-9481-5196d92bacae", "0003-iteration-augmented");
        Assertions.assertThat((Object)model).isNotNull();
        DMNContext context = DMNFactory.newContext();
        context.set("Loans", new HashMap());
        DMNResult result = runtime.evaluateAll(model, context);
        List decisionResults = result.getDecisionResults();
        FEELStringMarshaller.INSTANCE.marshall(Arrays.asList(((DMNDecisionResult)decisionResults.get(0)).getResult(), ((DMNDecisionResult)decisionResults.get(1)).getResult()));
    }

    private Definitions buildSimplifiedDefinitions(String namespace, String ... decisions) {
        TDefinitions def = new TDefinitions();
        def.setNamespace(namespace);
        for (String d : decisions) {
            TDecision dec = new TDecision();
            dec.setName(d);
            def.getDrgElement().add(dec);
            def.addChildren((DMNModelInstrumentedBase)dec);
            dec.setParent((DMNModelInstrumentedBase)def);
        }
        return def;
    }

    private DecisionNodeImpl buildSimplifiedDecisionNode(Definitions def, String name) {
        return new DecisionNodeImpl(def.getDrgElement().stream().filter(drg -> drg.getName().equals(name)).filter(Decision.class::isInstance).map(Decision.class::cast).findFirst().get());
    }

    @Test
    public void testCycleDetection() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        a.addDependency("b", (DMNNode)b);
        b.addDependency("a", (DMNNode)b);
        DMNModelImpl model = new DMNModelImpl(defs);
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(((Object)((Object)this)).getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }

    @Test
    public void testCycleDetectionSelfReference() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "self");
        DecisionNodeImpl decision = this.buildSimplifiedDecisionNode(defs, "self");
        decision.addDependency("self", (DMNNode)decision);
        DMNModelImpl model = new DMNModelImpl(defs);
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)decision);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(((Object)((Object)this)).getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }

    @Test
    public void testSharedDependency() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b", "c");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        DecisionNodeImpl c = this.buildSimplifiedDecisionNode(defs, "c");
        a.addDependency("c", (DMNNode)c);
        b.addDependency("c", (DMNNode)c);
        DMNModelImpl model = new DMNModelImpl(defs);
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        model.addDecision((DecisionNode)c);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(((Object)((Object)this)).getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assertions.assertThat((boolean)result.hasErrors()).isFalse();
    }

    @Test
    public void testCycleDetectionDeadlyDiamond() {
        Definitions defs = this.buildSimplifiedDefinitions("ns", "a", "b", "c", "d");
        DecisionNodeImpl a = this.buildSimplifiedDecisionNode(defs, "a");
        DecisionNodeImpl b = this.buildSimplifiedDecisionNode(defs, "b");
        DecisionNodeImpl c = this.buildSimplifiedDecisionNode(defs, "c");
        DecisionNodeImpl d = this.buildSimplifiedDecisionNode(defs, "d");
        a.addDependency("b", (DMNNode)b);
        a.addDependency("c", (DMNNode)c);
        b.addDependency("d", (DMNNode)d);
        c.addDependency("d", (DMNNode)d);
        DMNModelImpl model = new DMNModelImpl(defs);
        model.setDefinitions(defs);
        model.addDecision((DecisionNode)a);
        model.addDecision((DecisionNode)b);
        model.addDecision((DecisionNode)c);
        model.addDecision((DecisionNode)d);
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime(((Object)((Object)this)).getClass());
        DMNResult result = runtime.evaluateAll((DMNModel)model, DMNFactory.newContext());
        Assertions.assertThat((boolean)result.hasErrors()).isFalse();
    }

    @Test
    public void testEx_4_3simplified() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Ex_4_3simplified.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("number", (Object)123.123456);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Formatted Monthly Payment")).isEqualTo((Object)"\u20ac123.12");
    }

    @Test
    public void testEx_4_3simplifiedASD() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Ex_4_3simplified.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("number", (Object)"ciao");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getMessage().endsWith("is not allowed by the declared type (DMNType{ http://www.omg.org/spec/FEEL/20140401 : number })"))).isTrue();
    }

    @Test
    public void testDrools2125() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"drools2125.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_9f976b29-4cdd-42e9-8737-0ccbc2ad9498", "drools2125");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("person", (Object)"Bob");
        context.set("list of persons", Arrays.asList("Bob", "John"));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("person is Bob")).isEqualTo((Object)"yes");
        Assertions.assertThat((Object)result.get("persons complies with UT list")).isEqualTo((Object)"yes");
        Assertions.assertThat((Object)result.get("person on the list of persons")).isEqualTo((Object)"yes");
        Assertions.assertThat((Object)result.get("persons complies with hardcoded list")).isEqualTo((Object)"yes");
        Assertions.assertThat((Object)result.get("person is person")).isEqualTo((Object)"yes");
    }

    @Test
    public void testDROOLS2147() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DROOLS-2147.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_cbdacb7b-f72d-457d-b4f4-54020a06db24", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        List people = (List)resultContext.get("People");
        List peopleGroups = (List)resultContext.get("People groups");
        Assertions.assertThat((List)people).hasSize(6);
        Assertions.assertThat((List)peopleGroups).hasSize(3);
        Assertions.assertThat((List)((List)peopleGroups.get(0))).hasSize(2);
        Assertions.assertThat((List)((List)peopleGroups.get(1))).hasSize(2);
        Assertions.assertThat((List)((List)peopleGroups.get(2))).hasSize(2);
    }

    @Test
    public void testDROOLS2147_message() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Ex_4_3simplified.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_5c5a9c72-627e-4666-ae85-31356fed3658", "Ex_4_3simplified");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        StringBuilder sb = new StringBuilder("abcdefghijklmnopqrstuvwxyz");
        for (int i = 0; i < 100; ++i) {
            sb.append("abcdefghijklmnopqrstuvwxyz");
        }
        context.set("number", (Object)sb.toString());
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getMessage().contains("... [string clipped after 50 chars, total length is"))).isTrue();
    }

    @Test
    public void testDROOLS2192() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"hardcoded_function_definition.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_99854980-65c8-4e9b-b365-bd30ded69f40", "hardcoded_function_definition");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((int)((BigDecimal)resultContext.get("hardcoded decision")).intValue()).isEqualTo(47);
    }

    @Test
    public void testDROOLS2200() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"will_be_null_if_negative.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c5889555-7ae5-4a67-a872-3a9492caf6e7", "will be null if negative");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)-1);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat(((Map)resultContext.get("will be null if negative")).get("s1")).isNull();
        Assertions.assertThat(((Map)resultContext.get("will be null if negative")).get("s2")).isEqualTo((Object)"negative");
    }

    @Test
    public void testDROOLS2201() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("typecheck_in_context_result.dmn", ((Object)((Object)this)).getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_42bf043d-df86-48bd-9045-dfc08aa8ba0d", "typecheck in context result");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((Map)((Map)resultContext.get("an hardcoded person"))).containsKeys((Object[])new String[]{"name", "age"});
        Assertions.assertThat((Map)((Map)resultContext.get("an hardcoded person with no name"))).containsKeys((Object[])new String[]{"age"});
    }

    @Test
    public void testDROOLS2201b() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0"), (Resource[])new Resource[]{ks.getResources().newClassPathResource("typecheck_in_DT.dmn", ((Object)((Object)this)).getClass())});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_99ccd4df-41ac-43c3-a563-d58f43149829", "typecheck in DT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a number", (Object)0);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((int)((BigDecimal)resultContext.get("an odd decision")).intValue()).isEqualTo(47);
    }

    @Test
    public void testDROOLS2286() {
        DROOLS2286 johnCena = new DROOLS2286("John", "Cena");
        DROOLS2286 leslieBrown = new DROOLS2286("Leslie", "Brown");
        DROOLS2286 johnWick = new DROOLS2286("John", "Wick");
        ArrayList<DROOLS2286> personList = new ArrayList<DROOLS2286>();
        personList.add(johnCena);
        personList.add(leslieBrown);
        personList.add(johnWick);
        DMNContext context = DMNFactory.newContext();
        context.set("PersonList", personList);
        this.assertDROOLS2286(context);
    }

    @Test
    public void testDROOLS2286bis() {
        Map johnCena = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"surname", (Object)"Cena")});
        Map leslieBrown = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Leslie"), DynamicTypeUtils.entry((Object)"surname", (Object)"Brown")});
        Map johnWick = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"surname", (Object)"Wick")});
        ArrayList<Map> personList = new ArrayList<Map>();
        personList.add(johnCena);
        personList.add(leslieBrown);
        personList.add(johnWick);
        DMNContext context = DMNFactory.newContext();
        context.set("PersonList", personList);
        this.assertDROOLS2286(context);
    }

    private void assertDROOLS2286(DMNContext context) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"FilterJohns.dmn", ((Object)((Object)this)).getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_feb9886e-22ce-469a-bbb6-096f13b71c7d", "FilterJohns");
        DMNResult result = runtime.evaluateAll(model, context);
        ArrayList resultObject = (ArrayList)result.getDecisionResultByName("PickAllJohns").getResult();
        Assertions.assertThat((List)resultObject).hasSize(2);
    }

    @Test
    public void testVerifyExtendedKieFEELFunction_now() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"just_now.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_56fd6445-ff6a-4c28-8206-71fce7f80436", "just now");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("a decision just now").getResult()).isNotNull();
    }

    @Test
    public void testVerifyExtendedKieFEELFunction_today() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"just_today.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_56fd6445-ff6a-4c28-8206-71fce7f80436", "just today");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("a decision just today").getResult()).isNotNull();
    }

    @Test
    public void testEnhancedForLoop() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"drools2307.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_03d9481e-dcfc-4a59-9bdd-4f021cb2f0d8", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("an hardcoded forloop")).asList().containsExactly(new Object[]{new BigDecimal(2), new BigDecimal(3), new BigDecimal(4)});
    }

    @Test
    public void testList_of_Vowels() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"List_of_Vowels.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_c5f007ce-4d45-4aac-8729-991d4abc7826", "List of Vowels");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().filter(m -> m.getMessageType() == DMNMessageType.ERROR_EVAL_NODE).anyMatch(m -> m.getSourceId().equals("_b2205027-d06c-41b5-8419-e14b501e14a6"))).isTrue();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decide Vowel a")).isEqualTo((Object)"a");
        Assertions.assertThat((Object)result.get("Decide BAD")).isNull();
    }

    @Test
    public void testEnhancedForLoop2() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"MACD-enhanced_iteration.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6cfe7d88-6741-45d1-968c-b61a597d0964", "MACD-enhanced iteration");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        Map d1 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"aDate", (Object)LocalDate.of(2018, 3, 5)), DynamicTypeUtils.entry((Object)"Close", (Object)1010)});
        Map d2 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"aDate", (Object)LocalDate.of(2018, 3, 6)), DynamicTypeUtils.entry((Object)"Close", (Object)1020)});
        Map d3 = DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"aDate", (Object)LocalDate.of(2018, 3, 7)), DynamicTypeUtils.entry((Object)"Close", (Object)1030)});
        context.set("DailyTable", Arrays.asList(d1, d2, d3));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        LOG.debug("{}", (Object)dmnResult);
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat(((Map)((List)resultContext.get("MACDTable")).get(0)).get("aDate")).isEqualTo((Object)LocalDate.of(2018, 3, 5));
        Assertions.assertThat(((Map)((List)resultContext.get("MACDTable")).get(1)).get("aDate")).isEqualTo((Object)LocalDate.of(2018, 3, 6));
        Assertions.assertThat(((Map)((List)resultContext.get("MACDTable")).get(2)).get("aDate")).isEqualTo((Object)LocalDate.of(2018, 3, 7));
    }

    @Test
    public void testNotListInDT() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"anot.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_292c1c7b-6b38-415d-938f-e9ca51d30b2b", "anot");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("a letter", (Object)"a");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("what letter decision")).isEqualTo((Object)"vowel");
    }

    @Test
    public void testListContainmentDT() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"list_containment_DT.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6ab2bd6d-adaa-45c4-a141-a84382a201eb", "list containment DT");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Passenger", (Object)DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Osama bin Laden")}));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Boarding Status")).isEqualTo((Object)"Denied");
    }

    @Test
    public void testRelationwithemptycell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"relation_with_empty_cell.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_99a00903-2943-47df-bab1-a32f276617ea", "Relation with empty cell");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        System.out.println(dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decision A")).asList().containsExactly(new Object[]{DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", null), DynamicTypeUtils.entry((Object)"age", null)}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"John"), DynamicTypeUtils.entry((Object)"age", (Object)new BigDecimal(1))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", null), DynamicTypeUtils.entry((Object)"age", null)}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"name", (Object)"Matteo"), DynamicTypeUtils.entry((Object)"age", null)})});
    }

    @Test
    public void testFor() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Dynamic composition.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_c2d86765-c3c7-4e1d-b1fa-b830fa5bc529", "Dynamic composition");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testUsingReusableKeywordAsPartOfBKMName() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"say_for_hello.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_b6f2a9ca-a246-4f27-896a-e8ef04ea439c", "say for hello");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("just say")).asList().containsExactly(new Object[]{"Hello", "Hello", "Hello"});
    }

    @Test
    public void testProductFunction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"product.dmn", ((Object)((Object)this)).getClass());
        DMNModel model = runtime.getModel("http://www.trisotech.com/dmn/definitions/_40fdbc2c-a631-4ba4-8435-17571b5d1942", "Drawing 1");
        Assertions.assertThat((Object)model).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)model.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)model.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("product", (Object)new HashMap<String, Object>(){
            {
                this.put("name", "Product1");
                this.put("type", 1);
            }
        });
        DMNDecisionResult result = runtime.evaluateAll(model, context).getDecisionResultByName("TestDecision");
        Assertions.assertThat((boolean)result.hasErrors()).isFalse();
        Assertions.assertThat((Object)result.getResult()).isEqualTo((Object)"This is product 1");
    }

    @Test
    public void testNotWithPredicates20180601() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"test20180601.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_9b8f2642-2597-4a99-9fcd-f9302692d3dc", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context3 = DMNFactory.newContext();
        context3.set("my num", (Object)new BigDecimal(3));
        DMNResult dmnResult3 = runtime.evaluateAll(dmnModel, context3);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult3.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult3.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult3.getDecisionResultByName("my decision").getResult()).isEqualTo((Object)Boolean.FALSE);
        DMNContext context10 = DMNFactory.newContext();
        context10.set("my num", (Object)new BigDecimal(10));
        DMNResult dmnResult10 = runtime.evaluateAll(dmnModel, context10);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult10.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult10.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult10.getDecisionResultByName("my decision").getResult()).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testNotWithPredicates20180601b() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"BruceTask20180601.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_3802fcb2-5b93-4502-aff4-0f5c61244eab", "Bruce Task");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("TheBook", Arrays.asList(DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Title", (Object)"55"), DynamicTypeUtils.entry((Object)"Price", (Object)new BigDecimal(5)), DynamicTypeUtils.entry((Object)"Quantity", (Object)new BigDecimal(5))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Title", (Object)"510"), DynamicTypeUtils.entry((Object)"Price", (Object)new BigDecimal(5)), DynamicTypeUtils.entry((Object)"Quantity", (Object)new BigDecimal(10))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Title", (Object)"810"), DynamicTypeUtils.entry((Object)"Price", (Object)new BigDecimal(8)), DynamicTypeUtils.entry((Object)"Quantity", (Object)new BigDecimal(10))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Title", (Object)"85"), DynamicTypeUtils.entry((Object)"Price", (Object)new BigDecimal(8)), DynamicTypeUtils.entry((Object)"Quantity", (Object)new BigDecimal(5))}), DynamicTypeUtils.prototype((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"Title", (Object)"66"), DynamicTypeUtils.entry((Object)"Price", (Object)new BigDecimal(6)), DynamicTypeUtils.entry((Object)"Quantity", (Object)new BigDecimal(6))})));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Bruce")).isInstanceOf(Map.class);
        Map bruce = (Map)result.get("Bruce");
        Assertions.assertThat((List)((List)bruce.get("one"))).hasSize(2);
        Assertions.assertThat((boolean)((List)bruce.get("one")).stream().anyMatch(e -> ((Map)e).get("Title").equals("55"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("one")).stream().anyMatch(e -> ((Map)e).get("Title").equals("510"))).isTrue();
        Assertions.assertThat((List)((List)bruce.get("two"))).hasSize(3);
        Assertions.assertThat((boolean)((List)bruce.get("two")).stream().anyMatch(e -> ((Map)e).get("Title").equals("810"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("two")).stream().anyMatch(e -> ((Map)e).get("Title").equals("85"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("two")).stream().anyMatch(e -> ((Map)e).get("Title").equals("66"))).isTrue();
        Assertions.assertThat((List)((List)bruce.get("three"))).hasSize(1);
        Assertions.assertThat((boolean)((List)bruce.get("three")).stream().anyMatch(e -> ((Map)e).get("Title").equals("510"))).isTrue();
        Assertions.assertThat((List)((List)bruce.get("Four"))).hasSize(2);
        Assertions.assertThat((boolean)((List)bruce.get("Four")).stream().anyMatch(e -> ((Map)e).get("Title").equals("85"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("Four")).stream().anyMatch(e -> ((Map)e).get("Title").equals("66"))).isTrue();
        Assertions.assertThat((List)((List)bruce.get("Five"))).hasSize(2);
        Assertions.assertThat((boolean)((List)bruce.get("Five")).stream().anyMatch(e -> ((Map)e).get("Title").equals("85"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("Five")).stream().anyMatch(e -> ((Map)e).get("Title").equals("66"))).isTrue();
        Assertions.assertThat((List)((List)bruce.get("six"))).hasSize(2);
        Assertions.assertThat((boolean)((List)bruce.get("six")).stream().anyMatch(e -> ((Map)e).get("Title").equals("85"))).isTrue();
        Assertions.assertThat((boolean)((List)bruce.get("six")).stream().anyMatch(e -> ((Map)e).get("Title").equals("66"))).isTrue();
    }

    @Test
    public void testModelById() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"simple-item-def.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModelById("https://github.com/kiegroup/kie-dmn/itemdef", "_simple-item-def");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
    }

    @Test
    public void testWeekdayOnDateDMN12() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"weekday-on-date.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_55a2dafd-ab4d-4154-bace-826d426da251", "weekday on date");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        for (int i = 0; i < 7; ++i) {
            DMNContext context = DMNFactory.newContext();
            context.set("Run Date", (Object)LocalDate.of(2018, 6, 25).plusDays(i));
            DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
            LOG.debug("{}", (Object)dmnResult);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
            DMNContext result = dmnResult.getContext();
            Assertions.assertThat((Object)result.get("Weekday")).isEqualTo((Object)new BigDecimal(i + 1));
        }
    }

    @Test
    public void testDMN_Vs_FEEL_instanceof_interaction() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Instance_of.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_b5c4d644-5a15-4528-8028-86537cb1c836", "Instance of");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("input year month duration", (Object)Duration.parse("P12D"));
        context.set("input day time duration", (Object)Duration.parse("P1DT2H"));
        context.set("input date time", (Object)LocalDateTime.of(2018, 6, 28, 12, 34));
        context.set("input myType", (Object)LocalDate.of(2018, 6, 28));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Decision Logic 1")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Decision Logic 2")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Decision Logic 3")).isEqualTo((Object)Boolean.TRUE);
        Assertions.assertThat((Object)result.get("Decision Logic 4")).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void testInvokingAFunctionOnALiteralContext() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"invokingAFunctionOnALiteralContext.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_781968dd-64dc-4231-9cd0-2ce590881f2c", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("invoking a function on a literal context")).isEqualTo((Object)new BigDecimal(3));
    }

    @Test
    public void testBoxedInvocationMissingExpression() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"DROOLS-2813-NPE-BoxedInvocationMissingExpression.dmn", ((Object)((Object)this)).getClass());
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_a111c4df-c5b5-4d84-81e7-3ec735b50d06"))).isTrue();
    }

    @Test
    public void testNotHeuristicForFunctionInvocation() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"Not-heuristic-for-function-invocation-drools-2822.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_82f7e67e-0a8c-492d-aa78-94851c10eee6", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("Not working")).isEqualTo((Object)Boolean.FALSE);
    }

    @Test(timeout=30000L)
    public void testAccessorCache() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"20180731-pr1997.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_7a39d775-bce9-45e3-aa3b-147d6f0028c7", "20180731-pr1997");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        for (int i = 0; i < 10000; ++i) {
            DMNContext context = DMNFactory.newContext();
            context.set("a Person", (Object)new Person("John", "Doe", i));
            DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
            LOG.debug("{}", (Object)dmnResult);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
            DMNContext result = dmnResult.getContext();
            Assertions.assertThat((Object)result.get("Say hello and age")).isEqualTo((Object)("Hello John Doe, your age is: " + i));
        }
    }

    @Test
    public void testWrongTypeRefForDRGElement() {
        List messages = DMNRuntimeUtil.createExpectingDMNMessages((String)"WrongTypeRefForDRGElement.dmn", ((Object)((Object)this)).getClass());
        DMNRuntimeUtil.formatMessages((List)messages);
        Assertions.assertThat((List)messages).isNotEmpty();
        Assertions.assertThat((boolean)messages.stream().anyMatch(m -> m.getMessageType().equals((Object)DMNMessageType.TYPE_DEF_NOT_FOUND))).isTrue();
        Assertions.assertThat((boolean)messages.stream().anyMatch(m -> m.getSourceId().equals("_561d31ba-a34b-4cf3-b9a4-537e21ce1013"))).isTrue();
        Assertions.assertThat((boolean)messages.stream().anyMatch(m -> m.getSourceId().equals("_45fa8674-f4f0-4c06-b2fd-52bbd17d8550"))).isTrue();
    }

    @Test
    public void testDecisionTableInputClauseImportingItemDefinition() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"imports/Imported_Model.dmn", ((Object)((Object)this)).getClass(), (String[])new String[]{"imports/Importing_Person_DT_with_Person.dmn"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_3d586cb1-3ed0-4bc4-a1a7-070b70ece398", "Importing Person DT with Person");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("A Person here", (Object)DynamicTypeUtils.mapOf((Map.Entry[])new Map.Entry[]{DynamicTypeUtils.entry((Object)"age", (Object)new BigDecimal(17)), DynamicTypeUtils.entry((Object)"name", (Object)"John")}));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("A Decision Table")).isEqualTo((Object)"NOT Allowed");
    }

    @Test
    public void testAssignNullToAllowedValues() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"assignNullToAllowedValues.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_700a46e0-01ed-4361-9034-4afdb2537ea4", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("an input letter", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages());
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().anyMatch(m -> m.getSourceId().equals("_24e8b31b-9505-4f52-93af-6dd9ef39c72a"))).isTrue();
        Assertions.assertThat((boolean)dmnResult.getMessages().stream().anyMatch(m -> m.getSourceId().equals("_09945fda-2b89-4148-8758-0bcb91a66e4a"))).isTrue();
    }

    @Test
    public void testAssignNullToAllowedValuesExplicitingNull() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"assignNullToAllowedValuesExplicitingNull.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_700a46e0-01ed-4361-9034-4afdb2537ea4", "Drawing 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("an input letter", null);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("hardcoded letter").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("hardcoded letter").getResult()).isNull();
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("decision over the input letter").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("decision over the input letter").getResult()).isNull();
    }

    @Test
    public void testGetEntries() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"getentriesgetvalue.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_0fad1a80-0642-4278-ac3d-47668c4f689a", (String)"Drawing 1");
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("using get entries").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("using get entries").getResult()).asList().containsExactly(new Object[]{"value2"});
    }

    @Test
    public void testGetValue() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"getentriesgetvalue.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = DMNTestUtil.getAndAssertModelNoErrors((DMNRuntime)runtime, (String)"http://www.trisotech.com/dmn/definitions/_0fad1a80-0642-4278-ac3d-47668c4f689a", (String)"Drawing 1");
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)dmnResult.getDecisionResultByName("using get value").getEvaluationStatus()).isEqualTo((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("using get value").getResult()).isEqualTo((Object)"value2");
    }

    @Test
    public void testDTinputExprCollectionWithAllowedValuesA() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DROOLS-4379.dmn", ((Object)((Object)this)).getClass());
        this.testDTinputExprCollectionWithAllowedValues(runtime);
    }

    @Test
    public void testDTinputExprCollectionWithAllowedValuesB() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"DROOLS-4379b.dmn", ((Object)((Object)this)).getClass());
        this.testDTinputExprCollectionWithAllowedValues(runtime);
    }

    private void testDTinputExprCollectionWithAllowedValues(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_95436b7a-7268-4713-bf84-58bff10407b4", "Dessin 1");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("test", Arrays.asList("r2", "r1"));
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("D4")).isEqualTo((Object)"Contains r1");
        Assertions.assertThat((List)((List)result.get("D5"))).asList().contains(new Object[]{"r1", "r2"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEvaluateByNameWithEmptyParam() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"simple-item-def.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn/itemdef", "simple-item-def");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)1000);
        String[] decisionNames = new String[]{};
        runtime.evaluateByName(dmnModel, context, decisionNames);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEvaluateByIdWithEmptyParam() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"simple-item-def.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/kie-dmn/itemdef", "simple-item-def");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext context = DMNFactory.newContext();
        context.set("Monthly Salary", (Object)1000);
        String[] decisionIds = new String[]{};
        runtime.evaluateById(dmnModel, context, decisionIds);
    }

    @Test
    public void testUniqueMissingMatchDefaultEmpty() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"uniqueNoMatch.dmn", ((Object)((Object)this)).getClass());
        DMNModel dmnModel = runtime.getModel("http://activiti.org/schema/1.0/dmn", "decisionmulti");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        this.checkUniqueMissingMatchDefaultEmpty(runtime, dmnModel, 11, true);
        this.checkUniqueMissingMatchDefaultEmpty(runtime, dmnModel, 12, null);
    }

    private void checkUniqueMissingMatchDefaultEmpty(DMNRuntime runtime, DMNModel dmnModel, int input, Boolean output) {
        DMNContext context = DMNFactory.newContext();
        context.set("inputInteger", (Object)input);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Decision_decisionboolean").getResult()).isEqualTo((Object)output);
    }

    public static class DROOLS2286 {
        private String name;
        private String surname;

        DROOLS2286(String name, String surname) {
            this.name = name;
            this.surname = surname;
        }

        public String getName() {
            return this.name;
        }

        public String getSurname() {
            return this.surname;
        }
    }
}

