/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.legacy.tests.validation.v1_1;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorTest
extends AbstractValidatorTest {
    @Test
    public void testDryRun() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)definitions).isNotNull();
        DMNValidatorFactory.newValidator().validate(definitions);
    }

    @Test
    public void testMACDInputDefinitions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"MACD-enhanced_iteration.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6cfe7d88-6741-45d1-968c-b61a597d0964", "MACD-enhanced iteration");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)definitions).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
    }

    @Test
    public void testMACDInputReader() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/kie/dmn/core/MACD-enhanced_iteration.dmn"));){
            List messages = DMNValidatorFactory.newValidator().validate((Reader)reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
        }
    }

    private Definitions utilDefinitions(String filename, String modelName) {
        Definitions definitions;
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename));
        try {
            Definitions definitions2 = marshaller.unmarshal((Reader)isr);
            Assertions.assertThat((Object)definitions2).isNotNull();
            definitions = definitions2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                Assertions.fail((String)"Unable for the test suite to locate the file for validation.");
                return null;
            }
        }
        isr.close();
        return definitions;
    }

    @Test
    public void testInvalidXml() throws URISyntaxException {
        List validateXML = validator.validate(new File(((Object)((Object)this)).getClass().getResource("invalidXml.dmn").toURI()), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA});
        ((ListAssert)Assertions.assertThat((List)validateXML).as(ValidatorUtil.formatMessages((List)validateXML), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validateXML.get(0)).getMessageType()).as(((DMNMessage)validateXML.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.FAILED_XML_VALIDATION);
    }

    @Test
    public void testINVOCATION_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("INVOCATION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).as(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    public void testNAME_IS_VALID() {
        List validate = validator.validate(this.getReader("NAME_IS_VALID.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testNAME_INVALID_empty_name() {
        List validate = validator.validate(this.getReader("DROOLS-1447.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_5e43b55c-888e-443c-b1b9-80e4aa6746bd"))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_b1e4588e-9ce1-4474-8e4e-48dbcdb7524b"))).isTrue();
    }

    @Test
    public void testDRGELEM_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("DRGELEM_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    public void testFORMAL_PARAM_DUPLICATED() {
        List validate = validator.validate(this.getReader("FORMAL_PARAM_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(3);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_PARAM))).isTrue();
    }

    @Test
    public void testINVOCATION_INCONSISTENT_PARAM_NAMES() {
        List validate = validator.validate(this.getReader("INVOCATION_INCONSISTENT_PARAM_NAMES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH))).isTrue();
    }

    @Test
    @Ignore(value="Needs to be improved as invocations can be used to invoke functions node defined in BKMs. E.g., FEEL built in functions, etc.")
    public void testINVOCATION_MISSING_TARGET() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGET.dmn", "INVOCATION_MISSING_TARGET");
        List validate = validator.validate(definitions);
    }

    @Ignore(value="known current limitation")
    @Test
    public void testINVOCATION_MISSING_TARGETRbis() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGETbis.dmn", "INVOCATION_MISSING_TARGETbis");
        List validate = validator.validate(definitions);
    }

    @Test
    public void testINVOCATION_WRONG_PARAM_COUNT() {
        List validate = validator.validate(this.getReader("INVOCATION_WRONG_PARAM_COUNT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH))).isTrue();
    }

    @Test
    public void testITEMCOMP_DUPLICATED() {
        List validate = validator.validate(this.getReader("ITEMCOMP_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF))).isTrue();
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF))).isTrue();
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE_DROOLS_1450() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE_DROOLS-1450.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testRELATION_DUP_COLUMN() {
        List validate = validator.validate(this.getReader("RELATION_DUP_COLUMN.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_RELATION_COLUMN))).isTrue();
    }

    @Test
    public void testRELATION_ROW_CELL_NOTLITERAL() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELL_NOTLITERAL.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_NOT_LITERAL))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
    }

    @Test
    public void testRELATION_ROW_CELLCOUNTMISMATCH() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELLCOUNTMISMATCH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_COUNT_MISMATCH))).isTrue();
    }

    @Test
    public void testMortgageRecommender() {
        List validate = validator.validate(this.getReader("MortgageRecommender.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCEbis() {
        List validate = validator.validate(this.getReader("REQAUTH_NOT_KNOWLEDGESOURCEbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
    }

    @Test
    public void testVARIABLE_LEADING_TRAILING_SPACES() {
        List validate = validator.validate(this.getReader("VARIABLE_LEADING_TRAILING_SPACES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).isNotEmpty();
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_dd662d27-7896-42cb-9d14-bd74203bdbec");
        });
        Assertions.assertThat((List)validate).anySatisfy(p -> {
            Assertions.assertThat((Comparable)p.getMessageType()).isEqualTo((Object)DMNMessageType.INVALID_NAME);
            Assertions.assertThat((String)p.getSourceId()).isEqualTo("_1f54fd51-6805-4280-b576-607450f85edd");
        });
    }

    @Test
    public void testUNKNOWN_VARIABLE() {
        List validate = validator.validate(this.getReader("UNKNOWN_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }

    @Test
    public void testVALIDATION() {
        List validate = validator.validate(this.getReader("validation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(5);
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
        Assertions.assertThat((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }

    @Test
    public void testUsingSemanticNamespacePrefix() {
        List validate = validator.validate(this.getReader("UsingSemanticNS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testUsingSemanticNamespacePrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_semantic_namespace_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testNoPrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_no_prefix_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDecisionService20181008() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        List missingDMNImport = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB-missingDMNImport.dmn")});
        Assertions.assertThat((long)missingDMNImport.stream().filter(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND)).count()).isEqualTo(2L);
    }
}

