/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.jandex;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.junit.Test;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieDMNModelJandexTest {
    public static final Logger LOG = LoggerFactory.getLogger(KieDMNModelJandexTest.class);
    private final String moduleName = "kie-dmn-model";

    @Test
    public void testReflectConfigJSON() throws Exception {
        Indexer indexer = new Indexer();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("org/kie/dmn/model/api/DMNModelInstrumentedBase.class");
        indexer.index(stream);
        stream.close();
        this.scanFile(new File("./target/classes"), indexer);
        Index index = indexer.complete();
        Set founds = index.getAllKnownImplementors(DotName.createSimple((String)DMNModelInstrumentedBase.class.getCanonicalName()));
        LOG.debug("founds: \n{}", (Object)founds);
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)));
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (ClassInfo found : founds.stream().sorted(Comparator.comparing(ClassInfo::name)).collect(Collectors.toList())) {
            results.add(this.toReflectConfigMap(found));
        }
        LOG.debug("results: \n{}", results);
        String json = jsonb.toJson(results);
        LOG.debug("Expected reflect-config.json: \n{}", (Object)json);
        List fromJson = (List)jsonb.fromJson((Reader)new FileReader("src/main/resources/META-INF/native-image/org.kie/kie-dmn-model/reflect-config.json"), List.class);
        List dotNamesInJSON = fromJson.stream().map(m -> DotName.createSimple((String)((String)m.get("name")))).collect(Collectors.toList());
        Set foundsViaJandex = founds.stream().map(ClassInfo::name).collect(Collectors.toSet());
        Set foundsViaJSON = dotNamesInJSON.stream().collect(Collectors.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat(foundsViaJandex).as("List of classes found via Jandex during test and listed in JSON file must be same.", new Object[0])).isEqualTo(foundsViaJSON);
    }

    private Map<String, Object> toReflectConfigMap(ClassInfo found) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", found.name().toString());
        result.put("allDeclaredConstructors", true);
        result.put("allPublicConstructors", true);
        result.put("allDeclaredMethods", true);
        result.put("allPublicMethods", true);
        result.put("allDeclaredClasses", true);
        result.put("allPublicClasses", true);
        return result;
    }

    private void scanFile(File source, Indexer indexer) throws Exception {
        if (source.isDirectory()) {
            File[] children = source.listFiles();
            if (children == null) {
                throw new FileNotFoundException("Source directory disappeared: " + source);
            }
            for (File child : children) {
                this.scanFile(child, indexer);
            }
            return;
        }
        if (!source.getName().endsWith(".class")) {
            return;
        }
        LOG.trace("scan: {}", (Object)source);
        try (FileInputStream input = new FileInputStream(source);){
            indexer.index((InputStream)input);
        }
    }
}

