/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.io.IOException;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class ProcessItemTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("processItem.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        this.checkProcessItem(runtime, result);
    }

    private void checkProcessItem(DMNRuntime runtime, DMNOASResult result) throws IOException {
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_4B5AD433-0A08-4D69-A91F-89ECD6C2546F", "processItem");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"items\" : [ { \"id\" : 123 }, { \"id\" : 123 }] }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"items\" : [ { \"id\" : \"abc\" }, { \"id\" : \"abc\" }] }")).isEmpty();
    }

    @Test
    public void test_2() throws Exception {
        DMNRuntime runtime = this.createRuntime("processItem_2.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        this.checkProcessItem_2(runtime, result);
    }

    private void checkProcessItem_2(DMNRuntime runtime, DMNOASResult result) throws IOException {
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_4B5AD433-0A08-4D69-A91F-89ECD6C2546F_2", "processItem_2");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"items\" : [ { \"id\" : 123 }, { \"id\" : 123 }] }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"items\" : [ { \"id\" : \"abc\" }, { \"id\" : \"abc\" }] }")).isNotEmpty();
    }

    @Test
    public void test_together() throws Exception {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("processItem.dmn", this.getClass(), "processItem_2.dmn");
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        this.checkProcessItem(runtime, result);
        this.checkProcessItem_2(runtime, result);
    }
}

