/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.decisionservices.DMNDecisionServicesTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class DS004decisionservicesTest
extends BaseDMNOASTest {
    @Test
    public void test0004decisionservices_DS1() throws Exception {
        DMNRuntime runtime = this.createRuntime("0004-decision-services.dmn", DMNDecisionServicesTest.class);
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        ObjectNode syntheticJSONSchema = this.synthesizeSchemaForDS(result, modelUnderTest, "A only as output knowing D and E");
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":123, \"E\":456 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":\"d\", \"E\":\"e\" }")).isEmpty();
    }

    @Test
    public void test0004decisionservices_DS2() throws Exception {
        DMNRuntime runtime = this.createRuntime("0004-decision-services.dmn", DMNDecisionServicesTest.class);
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("http://www.trisotech.com/definitions/_686f58d4-4ec3-4c65-8c06-0e4fd8983def", "Decision Services");
        ObjectNode syntheticJSONSchema = this.synthesizeSchemaForDS(result, modelUnderTest, "A Only Knowing B and C");
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":123, \"E\":456 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":\"d\", \"E\":\"e\" }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":\"d\", \"E\":\"e\", \"B\":123, \"C\":123 }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"D\":\"d\", \"E\":\"e\", \"B\":\"b\", \"C\":\"c\" }")).isEmpty();
    }
}

