/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import io.smallrye.openapi.runtime.io.JsonUtil;
import java.io.IOException;
import java.util.Set;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.BaseVariantTest;
import org.kie.dmn.openapi.JacksonUtils;
import org.kie.dmn.openapi.model.DMNOASResult;

public abstract class BaseDMNOASTest {
    private ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).build();

    protected DMNRuntime createRuntime(String string, Class<?> class1) {
        return BaseVariantTest.VariantTestConf.KIE_API_TYPECHECK.createRuntime(string, class1);
    }

    protected DMNRuntime createRuntimeWithAdditionalResources(String string, Class<?> class1, String ... string2) {
        return BaseVariantTest.VariantTestConf.KIE_API_TYPECHECK.createRuntimeWithAdditionalResources(string, class1, string2);
    }

    protected JsonNode readJSON(String content) throws IOException {
        return this.mapper.readTree(content);
    }

    protected JsonSchema getJSONSchema(JsonNode schemaContent) {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4);
        return factory.getSchema(schemaContent);
    }

    protected Set<ValidationMessage> validateUsing(JsonSchema validator, String json) throws IOException {
        return validator.validate(this.readJSON(json));
    }

    protected ObjectNode synthesizeSchema(DMNOASResult result, DMNModel modelUnderTest) {
        DMNType InputSetTypeUT = result.lookupIOSetsByModel(modelUnderTest).getInputSet();
        return this.synthesizeSchema(result, InputSetTypeUT);
    }

    private ObjectNode synthesizeSchema(DMNOASResult result, DMNType InputSetTypeUT) {
        String dollarRef = result.getNamingPolicy().getRef(InputSetTypeUT);
        ObjectNode syntheticJSONSchema = result.getJsonSchemaNode().deepCopy();
        JsonUtil.stringProperty((ObjectNode)syntheticJSONSchema, (String)"$ref", (String)dollarRef);
        JacksonUtils.printoutJSON(syntheticJSONSchema);
        return syntheticJSONSchema;
    }

    protected ObjectNode synthesizeSchemaForDS(DMNOASResult result, DMNModel modelUnderTest, String dsName) {
        DMNType InputSetTypeUT = result.lookupIOSetsByModel(modelUnderTest).lookupDSIOSetsByName(dsName).getDSInputSet();
        return this.synthesizeSchema(result, InputSetTypeUT);
    }
}

