/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.stronglytyped.DMNRuntimeTypesTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class MultipleModelsTest
extends BaseDMNOASTest {
    @Test
    public void testNSEW() throws Exception {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("NSEW.dmn", DMNRuntimeTypesTest.class, "Traffic Violation.dmn");
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_FBA17BF4-BC04-4C16-9305-40E8B4B2FECB", "NSEW");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"asd\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"direction\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"direction\":\"Nord\" }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"direction\":\"North\" }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"direction\":\"North\", \"asd\":123 }")).isEmpty();
    }

    @Test
    public void testTF() throws Exception {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("NSEW.dmn", DMNRuntimeTypesTest.class, "Traffic Violation.dmn");
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"asd\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": {}, \"Violation\" : {} }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": { \"Points\": false}, \"Violation\" : {} }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": { \"Points\": 10 }, \"Violation\" : {} }")).isEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": { \"Points\": 10 }, \"Violation\" : {\"Type\": 123} }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": { \"Points\": 10 }, \"Violation\" : {\"Type\": \"string\"} }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{ \"Driver\": { \"Points\": 10 }, \"Violation\" : {\"Type\": \"speed\",\"Actual Speed\":140, \"Speed Limit\":100} }")).isEmpty();
    }
}

