/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.impl.FEELSchemaEnum;

public class FEELSchemaEnumTest
extends BaseDMNOASTest {
    @Test
    public void testBasic() {
        ArrayList<RangeImpl> list = new ArrayList<RangeImpl>();
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), null, Range.RangeBoundary.CLOSED));
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, null, (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED));
        Range result = FEELSchemaEnum.consolidateRanges(list);
        ((ObjectAssert)Assertions.assertThat((Object)result).isNotNull()).isEqualTo((Object)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED));
    }

    @Test
    public void testInvalidRepeatedLB() {
        ArrayList<RangeImpl> list = new ArrayList<RangeImpl>();
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), null, Range.RangeBoundary.CLOSED));
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED));
        Range result = FEELSchemaEnum.consolidateRanges(list);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void testInvalidRepeatedUB() {
        ArrayList<RangeImpl> list = new ArrayList<RangeImpl>();
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, null, (Comparable)Integer.valueOf(50), Range.RangeBoundary.CLOSED));
        list.add(new RangeImpl(Range.RangeBoundary.CLOSED, null, (Comparable)Integer.valueOf(100), Range.RangeBoundary.CLOSED));
        Range result = FEELSchemaEnum.consolidateRanges(list);
        Assertions.assertThat((Object)result).isNull();
    }
}

