/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.imports.ImportsTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class ImportingTest
extends BaseDMNOASTest {
    @Test
    public void testBasicImports() throws Exception {
        DMNRuntime runtime = this.createRuntimeWithAdditionalResources("baseSum.dmn", ImportsTest.class, "importingSum.dmn");
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("https://kiegroup.org/dmn/_1D35A3BF-1DBD-4CD0-882A-CA068C6F2A67", "importingSum");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"x\": 1, \"y\": 2 }")).isEmpty();
        String mutOutputSetName = result.getNamingPolicy().getName(result.lookupIOSetsByModel(modelUnderTest).getOutputSet());
        JsonNode mutOutputSet = syntheticJSONSchema.get("definitions").get(mutOutputSetName);
        Assertions.assertThat(() -> mutOutputSet.get("properties").fieldNames()).doesNotContain((Object[])new String[]{"baseSum Decision"});
        DMNModel importedModel = runtime.getModel("https://kiegroup.org/dmn/_FCC62740-4998-47A2-B5F2-CB3E15C98419", "baseSum");
        String importedOutputSetName = result.getNamingPolicy().getName(result.lookupIOSetsByModel(importedModel).getOutputSet());
        JsonNode importedOutputSet = syntheticJSONSchema.get("definitions").get(importedOutputSetName);
        Assertions.assertThat(() -> importedOutputSet.get("properties").fieldNames()).contains((Object[])new String[]{"baseSum Decision"});
    }
}

