/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.JacksonUtils;
import org.kie.dmn.openapi.model.DMNOASResult;

public class DMNDescriptionTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("dmnDescription.dmn", this.getClass());
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        JacksonUtils.printoutJSON(result.getJsonSchemaNode());
        JsonNode definitions = result.getJsonSchemaNode().get("definitions");
        ((MapAssert)Assertions.assertThat(this.convertToMap(definitions.get("InputSet").get("x-dmn-descriptions"))).hasSize(1)).containsEntry((Object)"in1", (Object)"description of in1");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(this.convertToMap(definitions.get("OutputSet").get("x-dmn-descriptions"))).hasSize(3)).containsEntry((Object)"in1", (Object)"description of in1")).containsEntry((Object)"out1", (Object)"description of out1")).containsEntry((Object)"d1", (Object)"description of d1");
        Assertions.assertThat(this.convertToMap(definitions.get("InputSetDSmyDS1").get("x-dmn-descriptions"))).hasSize(2);
        Assertions.assertThat(this.convertToMap(definitions.get("OutputSetDSmyDS1").get("x-dmn-descriptions"))).hasSize(1);
    }

    private Map<String, Object> convertToMap(JsonNode node) {
        return (Map)new ObjectMapper().convertValue((Object)node, Map.class);
    }
}

