/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.stronglytyped.DMNRuntimeTypesTest;
import org.kie.dmn.openapi.BaseDMNOASTest;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;

public class OneOfEachTypeTest
extends BaseDMNOASTest {
    @Test
    public void test() throws Exception {
        DMNRuntime runtime = this.createRuntime("OneOfEachType.dmn", DMNRuntimeTypesTest.class);
        DMNOASResult result = DMNOASGeneratorFactory.generator((Collection)runtime.getModels()).build();
        DMNModel modelUnderTest = runtime.getModel("http://www.trisotech.com/definitions/_4f5608e9-4d74-4c22-a47e-ab657257fc9c", "OneOfEachType");
        ObjectNode syntheticJSONSchema = this.synthesizeSchema(result, modelUnderTest);
        JsonSchema validator = this.getJSONSchema((JsonNode)syntheticJSONSchema);
        Assertions.assertThat(this.validateUsing(validator, "{ \"an order\":123 }")).isNotEmpty();
        Assertions.assertThat(this.validateUsing(validator, "{   \"InputBoolean\": true,\n    \"InputDTDuration\": \"P1D\",\n    \"InputDate\": \"2020-04-02\",\n    \"InputDateAndTime\": \"2020-04-02T09:00:00\",\n    \"InputNumber\": 1,\n    \"InputString\": \"John Doe\",\n    \"InputTime\": \"09:00:00\",\n    \"InputYMDuration\": \"P1M\"}")).isEmpty();
    }
}

