/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.pmml.DMNImportPMMLInfo;
import org.kie.dmn.core.pmml.DMNPMMLModelInfo;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.services.KieAssemblersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNRuntimePMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRuntimePMMLTest.class);
    private static final double COMPARISON_DELTA = 1.0E-6;

    @Test
    public void testBasic() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_scorecard.pmml"});
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(runtime);
    }

    @Test
    public void testWithInputTypes() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLScoreCard_wInputType.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_scorecard.pmml"});
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(runtime);
    }

    @Test
    public void testBasicNoKieAssembler() {
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().setRelativeImportResolver((ns, n, uri) -> new InputStreamReader(DMNRuntimePMMLTest.class.getResourceAsStream(uri))).buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newClassPathResource((String)"KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class))).getOrElseThrow(e -> new RuntimeException("Error compiling DMN model(s)", (Throwable)e));
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(dmnRuntime);
    }

    static void runDMNModelInvokingPMML(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f", "KiePMMLScoreCard");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("my decision"), (Matcher)CoreMatchers.is((Object)new BigDecimal("41.345")));
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assert.assertThat(pmmlImportInfo.keySet(), (Matcher)Matchers.hasSize((int)1));
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assert.assertThat((Object)p0.getImportName(), (Matcher)CoreMatchers.is((Object)"iris"));
        Assert.assertThat((Object)p0.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assert.assertThat((Object)m0.getName(), (Matcher)CoreMatchers.is((Object)"Sample Score"));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"age"), (Matcher)Matchers.anything()));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"occupation"), (Matcher)Matchers.anything()));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"residenceState"), (Matcher)Matchers.anything()));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"validLicense"), (Matcher)Matchers.anything()));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"overallScore"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)m0.getInputFields(), (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"calculatedScore"), (Matcher)Matchers.anything())));
        Assert.assertThat((Object)m0.getOutputFields(), (Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"calculatedScore"), (Matcher)Matchers.anything()));
    }

    @Test
    public void testSteppedCompilation() {
        KieAssemblersImpl assemblers = (KieAssemblersImpl)ServiceRegistry.getInstance().get(KieAssemblers.class);
        assemblers.accept((KieAssemblerService)new DMNAssemblerService());
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/acme/test_scorecard.pmml", ks.getResources().newClassPathResource("test_scorecard.pmml", DMNRuntimePMMLTest.class));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assert.assertEquals((long)0L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/org/acme/KiePMMLScoreCard.dmn", ks.getResources().newClassPathResource("KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class));
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/acme/KiePMMLScoreCard.dmn"}).build();
        Assert.assertEquals((long)0L, (long)addResults.getAddedMessages().size());
        Assert.assertEquals((long)0L, (long)addResults.getRemovedMessages().size());
        KieRepository kr = ks.getRepository();
        KieContainer kieContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kieContainer.getKieBase()).get(DMNRuntime.class);
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(dmnRuntime);
    }

    @Test
    public void testMultiOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLRegressionClax.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_regression_clax.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f", "KiePMMLRegressionClax");
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), (Object)dmnModel.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("fld1", (Object)1.0);
        dmnContext.set("fld2", (Object)1.0);
        dmnContext.set("fld3", (Object)"x");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext resultContext = dmnResult.getContext();
        Map result = (Map)resultContext.get("my decision");
        Assert.assertEquals((Object)"catD", (Object)((String)result.get("RegOut")));
        Assert.assertEquals((double)0.8279559384018024, (double)((BigDecimal)result.get("RegProb")).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0022681396056233208, (double)((BigDecimal)result.get("RegProbA")).doubleValue(), (double)1.0E-6);
        DMNType dmnFEELNumber = ((DMNModelImpl)dmnModel).getTypeRegistry().resolveType(dmnModel.getDefinitions().getURIFEEL(), BuiltInType.NUMBER.getName());
        DMNType dmnFEELString = ((DMNModelImpl)dmnModel).getTypeRegistry().resolveType(dmnModel.getDefinitions().getURIFEEL(), BuiltInType.STRING.getName());
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assert.assertThat(pmmlImportInfo.keySet(), (Matcher)Matchers.hasSize((int)1));
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assert.assertThat((Object)p0.getImportName(), (Matcher)CoreMatchers.is((Object)"test_regression_clax"));
        Assert.assertThat((Object)p0.getModels(), (Matcher)Matchers.hasSize((int)1));
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assert.assertThat((Object)m0.getName(), (Matcher)CoreMatchers.is((Object)"LinReg"));
        Map inputFields = m0.getInputFields();
        SimpleTypeImpl fld1 = (SimpleTypeImpl)inputFields.get("fld1");
        Assert.assertEquals((Object)"test_regression_clax", (Object)fld1.getNamespace());
        Assert.assertEquals((Object)BuiltInType.NUMBER, (Object)fld1.getFeelType());
        Assert.assertEquals((Object)dmnFEELNumber, (Object)fld1.getBaseType());
        SimpleTypeImpl fld2 = (SimpleTypeImpl)inputFields.get("fld2");
        Assert.assertEquals((Object)"test_regression_clax", (Object)fld2.getNamespace());
        Assert.assertEquals((Object)BuiltInType.NUMBER, (Object)fld2.getFeelType());
        Assert.assertEquals((Object)dmnFEELNumber, (Object)fld2.getBaseType());
        SimpleTypeImpl fld3 = (SimpleTypeImpl)inputFields.get("fld3");
        Assert.assertEquals((Object)"test_regression_clax", (Object)fld3.getNamespace());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)fld3.getFeelType());
        Assert.assertEquals((Object)dmnFEELString, (Object)fld3.getBaseType());
        Map outputFields = m0.getOutputFields();
        CompositeTypeImpl output = (CompositeTypeImpl)outputFields.get("LinReg");
        Assert.assertEquals((Object)"test_regression_clax", (Object)output.getNamespace());
        Map fields = output.getFields();
        SimpleTypeImpl regOut = (SimpleTypeImpl)fields.get("RegOut");
        Assert.assertEquals((Object)"test_regression_clax", (Object)regOut.getNamespace());
        Assert.assertEquals((Object)BuiltInType.STRING, (Object)regOut.getFeelType());
        Assert.assertEquals((Object)dmnFEELString, (Object)regOut.getBaseType());
        SimpleTypeImpl regProb = (SimpleTypeImpl)fields.get("RegProb");
        Assert.assertEquals((Object)"test_regression_clax", (Object)regProb.getNamespace());
        Assert.assertEquals((Object)BuiltInType.NUMBER, (Object)regProb.getFeelType());
        Assert.assertEquals((Object)dmnFEELNumber, (Object)regProb.getBaseType());
        SimpleTypeImpl regProbA = (SimpleTypeImpl)fields.get("RegProbA");
        Assert.assertEquals((Object)"test_regression_clax", (Object)regProbA.getNamespace());
        Assert.assertEquals((Object)BuiltInType.NUMBER, (Object)regProbA.getFeelType());
        Assert.assertEquals((Object)dmnFEELNumber, (Object)regProbA.getBaseType());
    }
}

