/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNRegressionPMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRegressionPMMLTest.class);

    @Test
    public void testRegression() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLRegression.dmn", DMNRegressionPMMLTest.class, (String[])new String[]{"test_regression.pmml"});
        Assertions.assertThat((Object)runtime).isNotNull();
        Assertions.assertThat((BigDecimal)this.evaluateRegressionDecision(runtime, 0.0, 0.0, "x")).isEqualTo((Object)BigDecimal.valueOf(-2.5));
        Assertions.assertThat((BigDecimal)this.evaluateRegressionDecision(runtime, 0.0, 0.0, "y")).isEqualTo((Object)BigDecimal.valueOf(3.5));
        Assertions.assertThat((BigDecimal)this.evaluateRegressionDecision(runtime, 3.0, 2.0, "y")).isEqualTo((Object)BigDecimal.valueOf(52.5));
        Assertions.assertThat((BigDecimal)this.evaluateRegressionDecision(runtime, 5.0, -1.0, "x")).isEqualTo((Object)BigDecimal.valueOf(120.5));
    }

    private BigDecimal evaluateRegressionDecision(DMNRuntime runtime, Double fld1, Double fld2, String fld3) {
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "TestRegressionDMN");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assertions.assertThat((boolean)dmnModel.hasErrors()).isFalse();
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("fld1", (Object)fld1);
        dmnContext.set("fld2", (Object)fld2);
        dmnContext.set("fld3", (Object)fld3);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((Object)resultContext).isNotNull();
        Assertions.assertThat((Object)resultContext.get("Decision")).isInstanceOf(BigDecimal.class);
        BigDecimal result = (BigDecimal)resultContext.get("Decision");
        return result;
    }
}

