/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.pmml.DMNRuntimePMMLTest;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public abstract class PMMLValidatorImportTest
extends AbstractValidatorTest {
    @Test
    public void testImportPMML() throws IOException {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("Invoke_Iris.dmn", PMMLValidatorImportTest.class)});
        Assert.assertThat((String)ValidatorUtil.formatMessages((List)messages), (Object)messages.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testImportPMML2() throws IOException {
        try (Reader defsReader = this.getReader("KiePMMLScoreCard_wInputType.dmn", DMNRuntimePMMLTest.class);){
            Definitions defs = this.getDefinitions(defsReader, "http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f", "KiePMMLScoreCard");
            DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver resolver = (ns, name, i) -> {
                if (ns.equals(defs.getNamespace()) && name.equals(defs.getName()) && i.equals(((Import)defs.getImport().get(0)).getLocationURI())) {
                    return this.getReader("test_scorecard.pmml", DMNRuntimePMMLTest.class);
                }
                return null;
            };
            List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingImports(resolver).theseModels(new Definitions[]{defs});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)messages), (Object)messages.size(), (Matcher)CoreMatchers.is((Object)0));
        }
    }
}

