/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNKMeansModelPMMLTest {
    private static final Logger LOG = LoggerFactory.getLogger(DMNKMeansModelPMMLTest.class);
    private DMNRuntime runtime;
    private DMNModel dmnModel;

    @Test
    public void testKMeans() {
        this.runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KMeans.dmn", DMNKMeansModelPMMLTest.class, (String[])new String[]{"test_kmeans.pmml"});
        this.dmnModel = this.runtime.getModel("https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456", "KMeansDMN");
        Assertions.assertThat((Object)this.dmnModel).isNotNull();
        Assertions.assertThat((boolean)this.dmnModel.hasErrors()).isFalse();
        Assertions.assertThat((String)this.findCluster(5, 5)).isEqualTo("4");
        Assertions.assertThat((String)this.findCluster(5, -5)).isEqualTo("1");
        Assertions.assertThat((String)this.findCluster(-5, 5)).isEqualTo("3");
        Assertions.assertThat((String)this.findCluster(-5, -5)).isEqualTo("2");
    }

    private String findCluster(int x, int y) {
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("x", (Object)x);
        dmnContext.set("y", (Object)y);
        DMNResult dmnResult = this.runtime.evaluateAll(this.dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Assertions.assertThat((Object)dmnResult.getDecisionResultByName("Decision1").getResult()).isNotNull();
        Map decisionResult = (Map)dmnResult.getDecisionResultByName("Decision1").getResult();
        String clusterName = (String)decisionResult.get("predictedValue");
        return clusterName;
    }
}

