/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNMiningModelPMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNMiningModelPMMLTest.class);

    @Test
    public void testMiningModelSum() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"SumMiningModel.dmn", DMNMiningModelPMMLTest.class, (String[])new String[]{"test_mining_model_summed.pmml"});
        Assertions.assertThat((BigDecimal)this.evaluateMiningModelDecision(runtime, 10.0, 10.0, 10.0)).isEqualTo((Object)new BigDecimal(2070));
        Assertions.assertThat((BigDecimal)this.evaluateMiningModelDecision(runtime, 200.0, -1.0, 2.0)).isEqualTo((Object)new BigDecimal(-299));
        Assertions.assertThat((BigDecimal)this.evaluateMiningModelDecision(runtime, 90.0, 2.0, 4.0)).isEqualTo((Object)new BigDecimal(17040));
    }

    private BigDecimal evaluateMiningModelDecision(DMNRuntime runtime, double input1, double input2, double input3) {
        DMNModel dmnModel = runtime.getModel("https://kiegroup.org/dmn/_0E8EC382-BB89-4877-8D37-A59B64285F05", "MiningModelDMN");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Assertions.assertThat((boolean)dmnModel.hasErrors()).isFalse();
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("input1", (Object)input1);
        dmnContext.set("input2", (Object)input2);
        dmnContext.set("input3", (Object)input3);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Assertions.assertThat((Object)resultContext).isNotNull();
        Assertions.assertThat((Object)resultContext.get("Decision")).isInstanceOf(BigDecimal.class);
        BigDecimal result = (BigDecimal)resultContext.get("Decision");
        return result;
    }
}

