/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.pmml.DMNImportPMMLInfo;
import org.kie.dmn.core.pmml.DMNPMMLModelInfo;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMNRuntimePMMLTest {
    public static final Logger LOG = LoggerFactory.getLogger(DMNRuntimePMMLTest.class);
    private static final double COMPARISON_DELTA = 1.0E-6;

    @Test
    public void testBasic() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_scorecard.pmml"});
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(runtime);
    }

    @Test
    public void testWithInputTypes() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLScoreCard_wInputType.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_scorecard.pmml"});
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(runtime);
    }

    @Test
    public void testBasicNoKieAssembler() {
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().setRelativeImportResolver((ns, n, uri) -> new InputStreamReader(DMNRuntimePMMLTest.class.getResourceAsStream(uri))).buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newClassPathResource((String)"KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class))).getOrElseThrow(e -> new RuntimeException("Error compiling DMN model(s)", (Throwable)e));
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(dmnRuntime);
    }

    static void runDMNModelInvokingPMML(DMNRuntime runtime) {
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f", "KiePMMLScoreCard");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext emptyContext = DMNFactory.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext result = dmnResult.getContext();
        Assertions.assertThat((Object)result.get("my decision")).isEqualTo((Object)new BigDecimal("41.345"));
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assertions.assertThat(pmmlImportInfo.keySet()).hasSize(1);
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assertions.assertThat((String)p0.getImportName()).isEqualTo("iris");
        Assertions.assertThat((Iterable)p0.getModels()).hasSize(1);
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assertions.assertThat((String)m0.getName()).isEqualTo("Sample Score");
        Assertions.assertThat((Map)m0.getInputFields()).containsKey((Object)"age");
        Assertions.assertThat((Map)m0.getInputFields()).containsKey((Object)"occupation");
        Assertions.assertThat((Map)m0.getInputFields()).containsKey((Object)"residenceState");
        Assertions.assertThat((Map)m0.getInputFields()).containsKey((Object)"validLicense");
        Assertions.assertThat((Map)m0.getInputFields()).doesNotContainKey((Object)"overallScore");
        Assertions.assertThat((Map)m0.getInputFields()).doesNotContainKey((Object)"calculatedScore");
        Assertions.assertThat((Map)m0.getOutputFields()).containsKey((Object)"calculatedScore");
    }

    @Test
    public void testSteppedCompilation() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/acme/test_scorecard.pmml", ks.getResources().newClassPathResource("test_scorecard.pmml", DMNRuntimePMMLTest.class));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll(DrlProject.class);
        Assertions.assertThat((List)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).hasSize(0);
        kfs.write("src/main/resources/org/acme/KiePMMLScoreCard.dmn", ks.getResources().newClassPathResource("KiePMMLScoreCard.dmn", DMNRuntimePMMLTest.class));
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/org/acme/KiePMMLScoreCard.dmn"}).build();
        Assertions.assertThat((List)addResults.getAddedMessages()).hasSize(0);
        Assertions.assertThat((List)addResults.getRemovedMessages()).hasSize(0);
        KieRepository kr = ks.getRepository();
        KieContainer kieContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kieContainer.getKieBase()).get(DMNRuntime.class);
        DMNRuntimePMMLTest.runDMNModelInvokingPMML(dmnRuntime);
    }

    @Test
    public void testMultiOutputs() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntimeWithAdditionalResources((String)"KiePMMLRegressionClax.dmn", DMNRuntimePMMLTest.class, (String[])new String[]{"test_regression_clax.pmml"});
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f", "KiePMMLRegressionClax");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnModel.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnModel.getMessages()), new Object[0])).isFalse();
        DMNContext dmnContext = DMNFactory.newContext();
        dmnContext.set("fld1", (Object)1.0);
        dmnContext.set("fld2", (Object)1.0);
        dmnContext.set("fld3", (Object)"x");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dmnResult.hasErrors()).as(DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), new Object[0])).isFalse();
        DMNContext resultContext = dmnResult.getContext();
        Map result = (Map)resultContext.get("my decision");
        Assertions.assertThat((String)((String)result.get("RegOut"))).isEqualTo("catD");
        Assertions.assertThat((double)((BigDecimal)result.get("RegProb")).doubleValue()).isCloseTo(0.8279559384018024, Assertions.within((Double)1.0E-6));
        Assertions.assertThat((double)((BigDecimal)result.get("RegProbA")).doubleValue()).isCloseTo(0.0022681396056233208, Assertions.within((Double)1.0E-6));
        DMNType dmnFEELNumber = ((DMNModelImpl)dmnModel).getTypeRegistry().resolveType(dmnModel.getDefinitions().getURIFEEL(), BuiltInType.NUMBER.getName());
        DMNType dmnFEELString = ((DMNModelImpl)dmnModel).getTypeRegistry().resolveType(dmnModel.getDefinitions().getURIFEEL(), BuiltInType.STRING.getName());
        Map pmmlImportInfo = ((DMNModelImpl)dmnModel).getPmmlImportInfo();
        Assertions.assertThat(pmmlImportInfo.keySet()).hasSize(1);
        DMNImportPMMLInfo p0 = (DMNImportPMMLInfo)pmmlImportInfo.values().iterator().next();
        Assertions.assertThat((String)p0.getImportName()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Iterable)p0.getModels()).hasSize(1);
        DMNPMMLModelInfo m0 = (DMNPMMLModelInfo)p0.getModels().iterator().next();
        Assertions.assertThat((String)m0.getName()).isEqualTo("LinReg");
        Map inputFields = m0.getInputFields();
        SimpleTypeImpl fld1 = (SimpleTypeImpl)inputFields.get("fld1");
        Assertions.assertThat((String)fld1.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)fld1.getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((Object)fld1.getBaseType()).isEqualTo((Object)dmnFEELNumber);
        SimpleTypeImpl fld2 = (SimpleTypeImpl)inputFields.get("fld2");
        Assertions.assertThat((String)fld2.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)fld2.getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((Object)fld2.getBaseType()).isEqualTo((Object)dmnFEELNumber);
        SimpleTypeImpl fld3 = (SimpleTypeImpl)inputFields.get("fld3");
        Assertions.assertThat((String)fld3.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)fld3.getFeelType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((Object)fld3.getBaseType()).isEqualTo((Object)dmnFEELString);
        Map outputFields = m0.getOutputFields();
        CompositeTypeImpl output = (CompositeTypeImpl)outputFields.get("LinReg");
        Assertions.assertThat((String)output.getNamespace()).isEqualTo("test_regression_clax");
        Map fields = output.getFields();
        SimpleTypeImpl regOut = (SimpleTypeImpl)fields.get("RegOut");
        Assertions.assertThat((String)regOut.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)regOut.getFeelType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((Object)regOut.getBaseType()).isEqualTo((Object)dmnFEELString);
        SimpleTypeImpl regProb = (SimpleTypeImpl)fields.get("RegProb");
        Assertions.assertThat((String)regProb.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)regProb.getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((Object)regProb.getBaseType()).isEqualTo((Object)dmnFEELNumber);
        SimpleTypeImpl regProbA = (SimpleTypeImpl)fields.get("RegProbA");
        Assertions.assertThat((String)regProbA.getNamespace()).isEqualTo("test_regression_clax");
        Assertions.assertThat((Object)regProbA.getFeelType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((Object)regProbA.getBaseType()).isEqualTo((Object)dmnFEELNumber);
    }
}

