/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.pmml;

import java.io.InputStream;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PMMLInfoTest {
    public static final Logger LOG = LoggerFactory.getLogger(PMMLInfoTest.class);

    @Test
    public void testPMMLInfo() throws Exception {
        InputStream inputStream = PMMLInfoTest.class.getResourceAsStream("test_scorecard.pmml");
        PMMLInfo p0 = PMMLInfo.from((InputStream)inputStream);
        Assertions.assertThat((Collection)p0.getModels()).hasSize(1);
        Assertions.assertThat((String)p0.getHeader().getPmmlNSURI()).isEqualTo("http://www.dmg.org/PMML-4_2");
        PMMLModelInfo m0 = (PMMLModelInfo)p0.getModels().iterator().next();
        Assertions.assertThat((String)m0.getName()).isEqualTo("Sample Score");
        Assertions.assertThat((Collection)m0.getInputFieldNames()).contains((Object[])new String[]{"age", "occupation", "residenceState", "validLicense"});
        Assertions.assertThat((Collection)m0.getTargetFieldNames()).contains((Object[])new String[]{"overallScore"});
        Assertions.assertThat((Collection)m0.getOutputFieldNames()).contains((Object[])new String[]{"calculatedScore"});
    }
}

