/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.ruleset2dmn.Converter;
import org.kie.dmn.ruleset2dmn.TestDMNRuntimeEventListener;
import org.kie.dmn.ruleset2dmn.TestUtils;
import org.kie.internal.io.ResourceFactory;

public class WifiTest {
    @Test
    public void test() throws Exception {
        String dmnXml = Converter.parse((String)"wifi", (InputStream)this.getClass().getResourceAsStream("/wifi.pmml"));
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newByteArrayResource((byte[])dmnXml.getBytes()))).getOrElseThrow(RuntimeException::new);
        dmnRuntime.addListener((DMNRuntimeEventListener)new TestDMNRuntimeEventListener());
        DMNModel modelUnderTest = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"X4\" : -61, \"X5\": -63}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)new BigDecimal("1"));
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"X1\" : -54}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)new BigDecimal("2"));
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"X5\" : -57, \"X1\": -46, \"X3\": -53, \"X7\": -73}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)new BigDecimal("3"));
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"nothing\" : 999}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)new BigDecimal("4"));
    }
}

