/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.io.InputStream;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.ruleset2dmn.Converter;
import org.kie.dmn.ruleset2dmn.TestDMNRuntimeEventListener;
import org.kie.dmn.ruleset2dmn.TestUtils;
import org.kie.internal.io.ResourceFactory;

public class IrisTest {
    @Test
    public void test() throws Exception {
        String dmnXml = Converter.parse((String)"iris", (InputStream)this.getClass().getResourceAsStream("/iris.pmml"));
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newByteArrayResource((byte[])dmnXml.getBytes()))).getOrElseThrow(RuntimeException::new);
        dmnRuntime.addListener((DMNRuntimeEventListener)new TestDMNRuntimeEventListener());
        DMNModel modelUnderTest = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"sepal_length\": 0.1, \"sepal_width\": 0.1, \"petal_length\": 3.5, \"petal_width\": 0.1}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"Iris-versicolor");
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"sepal_length\": 0.1, \"sepal_width\": 0.1, \"petal_length\": 0.1, \"petal_width\": 0.1}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"Iris-setosa");
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"sepal_length\": 47, \"sepal_width\": 0.1, \"petal_length\": 47, \"petal_width\": 0.1}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"Iris-versicolor");
        Assertions.assertThat((Object)((DMNDecisionResult)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{ \"sepal_length\": 999, \"sepal_width\": 999, \"petal_length\": 999, \"petal_width\": 999}")).getDecisionResults().get(0)).getResult()).isEqualTo((Object)"Iris-virginica");
    }
}

