/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.ruleset2dmn;

import java.io.InputStream;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.ruleset2dmn.Converter;
import org.kie.dmn.ruleset2dmn.TestDMNRuntimeEventListener;
import org.kie.dmn.ruleset2dmn.TestUtils;
import org.kie.internal.io.ResourceFactory;

public class ChurnRulesFromSPSSModelerTest {
    @Test
    public void test() throws Exception {
        String modelName = "ChurnSPSS";
        String dmnXml = Converter.parse((String)"ChurnSPSS", (InputStream)this.getClass().getResourceAsStream("/Churn Rules from SPSS Modeler.xml"));
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.singletonList(ResourceFactory.newByteArrayResource((byte[])dmnXml.getBytes()))).getOrElseThrow(RuntimeException::new);
        dmnRuntime.addListener((DMNRuntimeEventListener)new TestDMNRuntimeEventListener());
        DMNModel modelUnderTest = (DMNModel)dmnRuntime.getModels().get(0);
        Assertions.assertThat((Object)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"Gender\": \"F\", \"Status\": \"S\", \"Paymethod\": \"CC\", \"Est Income\": 21000, \"Local\": 11}")).getDecisionResultByName("ChurnSPSS").getResult()).isEqualTo((Object)"T");
        Assertions.assertThat((Object)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"LongDistance\": 9, \"Gender\": \"M\", \"Est Income\": 44000}")).getDecisionResultByName("ChurnSPSS").getResult()).isEqualTo((Object)"F");
        Assertions.assertThat((Object)dmnRuntime.evaluateAll(modelUnderTest, TestUtils.ctxFromJson(modelUnderTest, "{\"LongDistance\": 9}")).getDecisionResultByName("ChurnSPSS").getResult()).isEqualTo((Object)"F");
    }
}

