/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignavioTest {
    public static final Logger LOG = LoggerFactory.getLogger(SignavioTest.class);

    @Test
    public void test() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.signavio", "org.kie.dmn.signavio.KieDMNSignavioProfile");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource("Test_Signavio_multiple.dmn", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("persons", Arrays.asList("p1", "p2"));
        DMNModel model0 = (DMNModel)models.get(0);
        System.out.println("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        System.out.println(evaluateAll);
        Assert.assertThat((Object)((List)evaluateAll.getContext().get("Greeting for each Person in Persons")), (Matcher)Matchers.contains((Object[])new Object[]{"Hello p1", "Hello p2"}));
    }

    @Test
    public void testUsingSignavioFunctions() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.signavio", "org.kie.dmn.signavio.KieDMNSignavioProfile");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource("Using_Signavio_functions.dmn", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        DMNModel model0 = (DMNModel)models.get(0);
        System.out.println("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        System.out.println(evaluateAll);
        System.out.println(evaluateAll.getContext());
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertEquals((Object)true, (Object)evaluateAll.getContext().get("myContext"));
    }

    @Test
    public void testUsingSignavioFunctionsInLiteralExpression() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.signavio", "org.kie.dmn.signavio.KieDMNSignavioProfile");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource("Starts_with_an_A.dmn", this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        this.assertStartsWithAnA(runtime, "Abc", true);
        this.assertStartsWithAnA(runtime, "Xyz", false);
    }

    private void assertStartsWithAnA(DMNRuntime runtime, String testString, boolean startsWithAnA) {
        DMNContext context = runtime.newContext();
        context.set("surname", (Object)testString);
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertFalse((String)evaluateAll.getMessages().toString(), (boolean)evaluateAll.hasErrors());
        Assert.assertEquals((Object)startsWithAnA, (Object)evaluateAll.getContext().get("startsWithAnA"));
    }
}

