/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignavioTest {
    public static final Logger LOG = LoggerFactory.getLogger(SignavioTest.class);

    @Test
    public void test() {
        DMNRuntime runtime = this.createRuntime("Test_Signavio_multiple.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("persons", Arrays.asList("p1", "p2"));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        MatcherAssert.assertThat((Object)((List)evaluateAll.getContext().get("Greeting for each Person in Persons")), (Matcher)Matchers.contains((Object[])new Object[]{"Hello p1", "Hello p2"}));
    }

    @Test
    public void testUsingSignavioFunctions() {
        DMNRuntime runtime = this.createRuntime("Using_Signavio_functions.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        LOG.info("{}", (Object)evaluateAll.getContext());
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertEquals((Object)true, (Object)evaluateAll.getContext().get("myContext"));
    }

    @Test
    public void testUsingSignavioFunctionsInLiteralExpression() {
        DMNRuntime runtime = this.createRuntime("Starts_with_an_A.dmn");
        this.assertStartsWithAnA(runtime, "Abc", true);
        this.assertStartsWithAnA(runtime, "Xyz", false);
    }

    private void assertStartsWithAnA(DMNRuntime runtime, String testString, boolean startsWithAnA) {
        DMNContext context = runtime.newContext();
        context.set("surname", (Object)testString);
        DMNModel model0 = (DMNModel)runtime.getModels().get(0);
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        evaluateAll.getMessages().forEach(System.out::println);
        Assert.assertFalse((String)evaluateAll.getMessages().toString(), (boolean)evaluateAll.hasErrors());
        Assert.assertEquals((Object)startsWithAnA, (Object)evaluateAll.getContext().get("startsWithAnA"));
    }

    @Test
    public void testSurveyMIDSUM() {
        DMNRuntime runtime = this.createRuntime("survey MID SUM.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(6));
    }

    private void checkSurveryMID(DMNRuntime runtime, Object numbers, Object iterating) {
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("numbers", numbers);
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        MatcherAssert.assertThat((Object)evaluateAll.getDecisionResultByName("iterating").getResult(), (Matcher)Is.is((Object)iterating));
    }

    private DMNRuntime createRuntime(String modelFileName) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kmm = ks.newKieModuleModel();
        kmm.setConfigurationProperty("org.kie.dmn.profiles.signavio", "org.kie.dmn.signavio.KieDMNSignavioProfile");
        kfs.writeKModuleXML(kmm.toXML());
        kfs.write(ks.getResources().newClassPathResource(modelFileName, this.getClass()));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Results results = kieBuilder.getResults();
        LOG.info("buildAll() completed.");
        results.getMessages(new Message.Level[]{Message.Level.WARNING}).forEach(e -> LOG.warn("{}", e));
        Assert.assertTrue((results.getMessages(new Message.Level[]{Message.Level.WARNING}).size() == 0 ? 1 : 0) != 0);
        KieContainer kieContainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        return runtime;
    }

    @Test
    public void testSurveyMIDMIN() {
        DMNRuntime runtime = this.createRuntime("survey MID MIN.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(1));
    }

    @Test
    public void testSurveyMIDMAX() {
        DMNRuntime runtime = this.createRuntime("survey MID MAX.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2, 3), new BigDecimal(3));
    }

    @Test
    public void testSurveyMIDCOUNT() {
        DMNRuntime runtime = this.createRuntime("survey MID COUNT.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 1, 1), new BigDecimal(3));
    }

    @Test
    public void testSurveyMIDALLTRUE() {
        DMNRuntime runtime = this.createRuntime("survey MID ALLTRUE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2), true);
        this.checkSurveryMID(runtime, Arrays.asList(-1, 2), false);
    }

    @Test
    public void testSurveyMIDANYTRUE() {
        DMNRuntime runtime = this.createRuntime("survey MID ANYTRUE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, -2), true);
        this.checkSurveryMID(runtime, Arrays.asList(-1, -2), false);
    }

    @Test
    public void testSurveyMIDALLFALSE() {
        DMNRuntime runtime = this.createRuntime("survey MID ALLFALSE.dmn");
        this.checkSurveryMID(runtime, Arrays.asList(1, 2), false);
        this.checkSurveryMID(runtime, Arrays.asList(-1, 2), false);
        this.checkSurveryMID(runtime, Arrays.asList(1, -2), false);
        this.checkSurveryMID(runtime, Arrays.asList(-1, -2), true);
    }

    @Test
    public void testZipFunctions() {
        DMNRuntime runtime = this.createRuntime("Test_SignavioZipFunctions.dmn");
        this.checkBothFunctionsAreWorking(runtime);
    }

    @Test
    public void testMidTakesCareOfRequirements() {
        DMNRuntime runtime = this.createRuntime("Test_SignavioMID.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("numbers1", Arrays.asList(1, 2));
        context.set("numbers2", Arrays.asList(2, 3));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        List result = (List)evaluateAll.getDecisionResultByName("calculate").getResult();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.iterableWithSize((int)6));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testSignavioConcatFunction() {
        DMNRuntime runtime = this.createRuntime("Signavio_Concat.dmn");
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("listOfNames", Arrays.asList("John", "Jane", "Doe"));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        Assert.assertEquals((Object)"JohnJaneDoe", (Object)evaluateAll.getDecisionResultByName("concatNames").getResult());
    }

    private void checkBothFunctionsAreWorking(DMNRuntime runtime) {
        List models = runtime.getModels();
        DMNContext context = runtime.newContext();
        context.set("names", Arrays.asList("John Doe", "Jane Doe"));
        context.set("ages", Arrays.asList(37, 35));
        DMNModel model0 = (DMNModel)models.get(0);
        LOG.info("EVALUATE ALL:");
        DMNResult evaluateAll = runtime.evaluateAll(model0, context);
        LOG.info("{}", (Object)evaluateAll);
        MatcherAssert.assertThat((Object)((List)evaluateAll.getDecisionResultByName("zipvararg").getResult()), (Matcher)Matchers.iterableWithSize((int)2));
        MatcherAssert.assertThat((Object)((List)evaluateAll.getDecisionResultByName("zipsinglelist").getResult()), (Matcher)Matchers.iterableWithSize((int)2));
    }
}

