/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.signavio.MultiInstanceDecisionLogic;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MultiInstanceDecisionLogicTest {
    private static final String ITERATOR = "I1";
    private static final String TOP_LEVEL = "A";
    @Mock
    private MultiInstanceDecisionLogic mid;
    @Mock
    private DMNModel model;

    @Before
    public void setup() {
        MockitoAnnotations.openMocks((Object)this);
        ((MultiInstanceDecisionLogic)Mockito.doReturn((Object)TOP_LEVEL).when((Object)this.mid)).getTopLevelDecisionId();
        ((MultiInstanceDecisionLogic)Mockito.doReturn((Object)ITERATOR).when((Object)this.mid)).getIteratorShapeId();
        DMNBaseNode a = this.decision(TOP_LEVEL);
        DMNBaseNode b = this.decision("B");
        DMNBaseNode c = this.decision("C");
        DMNBaseNode d = this.decision("D");
        DMNBaseNode i1 = this.input(ITERATOR);
        DMNBaseNode i2 = this.input("I2");
        this.connect(a, Arrays.asList(b, c));
        this.connect(b, Arrays.asList(i1));
        this.connect(c, Arrays.asList(i1, d));
        this.connect(d, Arrays.asList(i2));
    }

    private void connect(DMNBaseNode node, List<DMNNode> dependencies) {
        Map deps = dependencies.stream().collect(Collectors.toMap(DMNNode::getId, Function.identity()));
        ((DMNBaseNode)Mockito.doReturn(deps).when((Object)node)).getDependencies();
    }

    private DMNBaseNode decision(String id) {
        DecisionNodeImpl decision = (DecisionNodeImpl)Mockito.mock(DecisionNodeImpl.class);
        ((DecisionNodeImpl)Mockito.doReturn((Object)id).when((Object)decision)).getId();
        ((DMNModel)Mockito.doReturn((Object)decision).when((Object)this.model)).getDecisionById(id);
        return decision;
    }

    private DMNBaseNode input(String id) {
        InputDataNodeImpl input = (InputDataNodeImpl)Mockito.mock(InputDataNodeImpl.class);
        ((InputDataNodeImpl)Mockito.doReturn((Object)id).when((Object)input)).getId();
        ((DMNModel)Mockito.doReturn((Object)input).when((Object)this.model)).getInputById(id);
        return input;
    }

    @Test
    public void thatFindAllChildElements_withMid_collectsCorrectChildsAndSkipsExternals() {
        MultiInstanceDecisionLogic.MIDDependenciesProcessor processor = new MultiInstanceDecisionLogic.MIDDependenciesProcessor(this.mid, this.model);
        Collection innerNodes = processor.findAllChildElements();
        Collection ids = innerNodes.stream().map(DMNNode::getId).collect(Collectors.toList());
        Assertions.assertThat((Iterable)ids).contains((Object[])new String[]{TOP_LEVEL, "B", "C", ITERATOR});
        Assertions.assertThat((Iterable)ids).hasSize(4);
    }
}

