/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.backend.marshalling.v1_3.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_3.xstream.ExpressionConverter;
import org.kie.dmn.backend.marshalling.v1x.ConverterDefinesExpressionNodeName;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.trisotech.model.api.Iterator;
import org.kie.dmn.trisotech.model.api.NamedExpression;
import org.kie.dmn.trisotech.model.v1_3.TIterator;
import org.kie.dmn.trisotech.model.v1_3.TNamedExpression;

public class IteratorConverter
extends ExpressionConverter
implements ConverterDefinesExpressionNodeName {
    public static final String VARIABLE = "iteratorVariable";
    public static final String TYPE = "iteratorType";
    public static final String IN = "in";
    public static final String RETURN = "return";

    protected void assignChildElement(Object parent, String nodeName, Object child) {
        Iterator filter = (Iterator)parent;
        if (IN.equals(nodeName)) {
            filter.setIn(((NamedExpression)child).getExpression());
        } else if (RETURN.equals(nodeName)) {
            filter.setReturn(((NamedExpression)child).getExpression());
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
        Iterator filter = (Iterator)parent;
        String type = reader.getAttribute(TYPE);
        if (type == null) {
            type = "for";
        }
        switch (type) {
            default: {
                filter.setIteratorType(Iterator.IteratorType.FOR);
                break;
            }
            case "some": {
                filter.setIteratorType(Iterator.IteratorType.SOME);
                break;
            }
            case "every": {
                filter.setIteratorType(Iterator.IteratorType.EVERY);
            }
        }
        filter.setVariable(reader.getAttribute(VARIABLE));
    }

    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        Iterator it = (Iterator)parent;
        this.writeChildrenNode(writer, context, new TNamedExpression(IN, it.getIn()), IN);
        this.writeChildrenNode(writer, context, new TNamedExpression(RETURN, it.getReturn()), RETURN);
    }

    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
        Iterator it = (Iterator)parent;
        writer.addAttribute(TYPE, it.getIteratorType().toString().toLowerCase());
        writer.addAttribute(VARIABLE, it.getVariable());
    }

    public IteratorConverter(XStream xstream) {
        super(xstream);
    }

    protected DMNModelInstrumentedBase createModelObject() {
        return new TIterator();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(TIterator.class);
    }

    public String defineExpressionNodeName(Expression e) {
        return "iterator";
    }
}

