/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core.compiler;

import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.trisotech.core.ast.DMNConditionalEvaluator;
import org.kie.dmn.trisotech.core.ast.DMNFilterEvaluator;
import org.kie.dmn.trisotech.core.ast.DMNIteratorEvaluator;
import org.kie.dmn.trisotech.core.util.Msg;
import org.kie.dmn.trisotech.model.api.Conditional;
import org.kie.dmn.trisotech.model.api.Filter;
import org.kie.dmn.trisotech.model.api.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrisotechDMNEvaluatorCompiler
extends DMNEvaluatorCompiler {
    private static final Logger logger = LoggerFactory.getLogger(TrisotechDMNEvaluatorCompiler.class);

    protected TrisotechDMNEvaluatorCompiler(DMNCompilerImpl compiler) {
        super(compiler);
    }

    public DMNExpressionEvaluator compileExpression(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Expression expression) {
        if (expression instanceof Conditional) {
            return this.compileConditional(ctx, model, node, exprName, (Conditional)expression);
        }
        if (expression instanceof Iterator) {
            return this.compileIterator(ctx, model, node, exprName, (Iterator)expression);
        }
        if (expression instanceof Filter) {
            return this.compileFilter(ctx, model, node, exprName, (Filter)expression);
        }
        return super.compileExpression(ctx, model, node, exprName, expression);
    }

    private DMNExpressionEvaluator compileConditional(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Conditional expression) {
        DMNExpressionEvaluator ifEvaluator = this.compileExpression(ctx, model, node, exprName + " [if]", expression.getIf());
        DMNExpressionEvaluator thenEvaluator = this.compileExpression(ctx, model, node, exprName + " [then]", expression.getThen());
        DMNExpressionEvaluator elseEvaluator = this.compileExpression(ctx, model, node, exprName + " [else]", expression.getElse());
        if (ifEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_CONDITION, (Object)"if", (Object)node.getIdentifierString());
            return null;
        }
        if (thenEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_CONDITION, (Object)"then", (Object)node.getIdentifierString());
            return null;
        }
        if (elseEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_CONDITION, (Object)"else", (Object)node.getIdentifierString());
            return null;
        }
        return new DMNConditionalEvaluator(exprName, (DMNElement)node.getSource(), ifEvaluator, thenEvaluator, elseEvaluator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileIterator(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Iterator expression) {
        if (expression.getVariable() == null || expression.getVariable().length() == 0) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_ITERATOR, (Object)expression.getTypeRef().toString().toLowerCase(), (Object)node.getIdentifierString());
            return null;
        }
        DMNExpressionEvaluator inEvaluator = null;
        DMNExpressionEvaluator returnEvaluator = null;
        inEvaluator = this.compileExpression(ctx, model, node, exprName + " [in]", expression.getIn());
        try {
            DMNType outputType;
            ctx.enterFrame();
            DMNType elementType = outputType = this.compiler.resolveTypeRef(model, null, (DMNModelInstrumentedBase)node.getSource(), expression.getTypeRef());
            ctx.setVariable(expression.getVariable(), elementType != null ? elementType : model.getTypeRegistry().unknown());
            ctx.setVariable("partial", outputType != null ? outputType : model.getTypeRegistry().unknown());
            returnEvaluator = this.compileExpression(ctx, model, node, exprName + " [return]", expression.getReturn());
        }
        finally {
            ctx.exitFrame();
        }
        if (inEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_ITERATOR, (Object)"in", (Object)node.getIdentifierString());
            return null;
        }
        if (returnEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_ITERATOR, (Object)(expression.getIteratorType() == Iterator.IteratorType.FOR ? "return" : "satisfies"), (Object)node.getIdentifierString());
            return null;
        }
        return new DMNIteratorEvaluator(exprName, (DMNElement)node.getSource(), expression.getIteratorType(), expression.getVariable(), inEvaluator, returnEvaluator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMNExpressionEvaluator compileFilter(DMNCompilerContext ctx, DMNModelImpl model, DMNBaseNode node, String exprName, Filter expression) {
        DMNExpressionEvaluator filterEvaluator;
        DMNExpressionEvaluator inEvaluator = this.compileExpression(ctx, model, node, exprName + " [in]", expression.getIn());
        try {
            DMNType outputType;
            ctx.enterFrame();
            DMNType elementType = outputType = this.compiler.resolveTypeRef(model, null, (DMNModelInstrumentedBase)node.getSource(), expression.getTypeRef());
            ctx.setVariable("item", elementType != null ? elementType : model.getTypeRegistry().unknown());
            if (elementType != null && elementType.isComposite()) {
                elementType.getFields().forEach((k, v) -> ctx.setVariable(k, v != null ? v : model.getTypeRegistry().unknown()));
            }
            filterEvaluator = this.compileExpression(ctx, model, node, exprName + " [filter]", expression.getMatch());
        }
        finally {
            ctx.exitFrame();
        }
        if (inEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_FILTER, (Object)"in", (Object)node.getIdentifierString());
            return null;
        }
        if (filterEvaluator == null) {
            MsgUtil.reportMessage((Logger)logger, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), (DMNMessageManager)model, null, null, (Msg.Message2)Msg.MISSING_EXPRESSION_FOR_FILTER, (Object)"filter", (Object)node.getIdentifierString());
            return null;
        }
        return new DMNFilterEvaluator(exprName, (DMNElement)node.getSource(), inEvaluator, filterEvaluator);
    }
}

