/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNDecisionLogicCompilerFactory;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.trisotech.TrisotechDMNProfile;
import org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory;

@RunWith(value=Parameterized.class)
public class DMN14ExpressionsTest {
    private DMNRuntime runtime;
    private DMNModel model;
    private TestStrategy testConfig;

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new Object[]{TestStrategy.KIE_API, TestStrategy.DMNRUNTIMEBUILDER};
    }

    public DMNRuntime createRuntime(String model, Class<?> class1) {
        if (this.testConfig == TestStrategy.DMNRUNTIMEBUILDER) {
            return this.createRuntimeUsingBuilder(model, class1);
        }
        return this.createRuntimeUsingKieAPI(model, class1);
    }

    public DMNRuntime createRuntimeUsingKieAPI(String model, Class<?> class1) {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource modelResource = ks.getResources().newClassPathResource(model, class1);
        kfs.write(modelResource);
        kfs.writeKModuleXML("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <configuration>\n    <property key=\"org.kie.dmn.profiles.trisotech\" value=\"org.kie.dmn.trisotech.TrisotechDMNProfile\"/>\n    <property key=\"org.kie.dmn.decisionlogiccompilerfactory\" value=\"org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory\"/>\n  </configuration>\n</kmodule>");
        kfs.generateAndWritePomXML(releaseId);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((String)kieBuilder.getResults().getMessages().toString(), (boolean)kieBuilder.getResults().getMessages().isEmpty());
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        DMNRuntime runtime = DMNRuntimeUtil.typeSafeGetKieRuntime((KieContainer)kieContainer);
        return runtime;
    }

    public DMNRuntime createRuntimeUsingBuilder(String model, Class<?> class1) {
        return (DMNRuntime)DMNRuntimeBuilder.fromDefaults().addProfile((DMNProfile)new TrisotechDMNProfile()).setDecisionLogicCompilerFactory((DMNDecisionLogicCompilerFactory)new TrisotechDMNEvaluatorCompilerFactory()).buildConfiguration().fromClasspathResource(model, class1).getOrElseThrow(e -> new RuntimeException("Error initalizing DMNRuntime", (Throwable)e));
    }

    public DMN14ExpressionsTest(TestStrategy testConfig) {
        this.testConfig = testConfig;
    }

    @Before
    public void setup() {
        this.runtime = this.createRuntime("dmn14expressions.dmn", DMN14ExpressionsTest.class);
        Assertions.assertThat((Object)this.runtime).isNotNull();
        this.model = this.runtime.getModel("http://www.trisotech.com/definitions/_3404349f-5046-4ad3-ad15-7f1e27291ab5", "DMN 1.4 expressions");
        Assertions.assertThat((Object)this.model).isNotNull();
    }

    @Test
    public void testConditionalWithInput() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", true)), new String[]{"Conditional"});
        Assert.assertEquals((Object)"Conditional evaluated to TRUE", (Object)results.getDecisionResultByName("Conditional").getResult());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", false)), new String[]{"Conditional"});
        Assert.assertEquals((Object)"Conditional evaluated to FALSE", (Object)results.getDecisionResultByName("Conditional").getResult());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", null)), new String[]{"Conditional"});
        Assert.assertEquals((Object)"Conditional evaluated to FALSE", (Object)results.getDecisionResultByName("Conditional").getResult());
    }

    @Test
    public void testConditionalNonBooleanIf() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(), new String[]{"Non boolean"});
        Assert.assertEquals((long)1L, (long)results.getMessages().size());
        Assert.assertEquals((Object)DMNMessageType.ERROR_EVAL_NODE, (Object)((DMNMessage)results.getMessages().iterator().next()).getMessageType());
    }

    @Test
    public void testIteratorFor() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition"});
        Assert.assertEquals((Object)Arrays.asList(2, 3, 4, 5).toString(), (Object)results.getDecisionResultByName("Addition").getResult().toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition"});
        Assert.assertEquals((Object)Arrays.asList(3, 4, 5, 6).toString(), (Object)results.getDecisionResultByName("Addition").getResult().toString());
    }

    @Test
    public void testIteratorForPartial() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 0)), new String[]{"Addition Partial"});
        Assert.assertEquals((Object)Arrays.asList(1, 3, 6, 10).toString(), (Object)results.getDecisionResultByName("Addition Partial").getResult().toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Addition Partial"});
        Assert.assertEquals((Object)Arrays.asList(1, 8, 16, 25).toString(), (Object)results.getDecisionResultByName("Addition Partial").getResult().toString());
    }

    @Test
    public void testIteratorForInRangeClose() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition Range Close"});
        Assert.assertEquals((Object)Arrays.asList(3, 4).toString(), (Object)results.getDecisionResultByName("Addition Range Close").getResult().toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition Range Close"});
        Assert.assertEquals((Object)Arrays.asList(4, 5).toString(), (Object)results.getDecisionResultByName("Addition Range Close").getResult().toString());
    }

    @Test
    public void testIteratorForInRangeOpen() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition Range Open"});
        Assert.assertEquals((Object)Arrays.asList(2, 3, 4, 5).toString(), (Object)results.getDecisionResultByName("Addition Range Open").getResult().toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition Range Open"});
        Assert.assertEquals((Object)Arrays.asList(3, 4, 5, 6).toString(), (Object)results.getDecisionResultByName("Addition Range Open").getResult().toString());
    }

    @Test
    public void testIteratorSome() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Number Greater Exists"});
        Assert.assertTrue((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult()));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -1)), new String[]{"Number Greater Exists"});
        Assert.assertTrue((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult()));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"Number Greater Exists"});
        Assert.assertFalse((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult()));
    }

    @Test
    public void testIteratorEvery() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"All Greater"});
        Assert.assertFalse((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult()));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -1)), new String[]{"All Greater"});
        Assert.assertTrue((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult()));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"All Greater"});
        Assert.assertFalse((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult()));
    }

    @Test
    public void testFilterIndex() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Match by index"});
        Assert.assertEquals((Object)new BigDecimal(5), (Object)results.getDecisionResultByName("Match by index").getResult());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -2)), new String[]{"Match by index"});
        Assert.assertEquals((Object)new BigDecimal(9), (Object)results.getDecisionResultByName("Match by index").getResult());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 0)), new String[]{"Match by index"});
        Assert.assertTrue((results.getMessages().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterExpression() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Match by Fnct"});
        Assert.assertEquals((Object)Arrays.asList(6, 7, 8, 9, 10).toString(), (Object)results.getDecisionResultByName("Match by Fnct").getResult().toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"Match by Fnct"});
        Assert.assertEquals((Object)Arrays.asList(new Object[0]).toString(), (Object)results.getDecisionResultByName("Match by Fnct").getResult().toString());
    }

    public static enum TestStrategy {
        KIE_API,
        DMNRUNTIMEBUILDER;

    }
}

