/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNDecisionLogicCompilerFactory;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.trisotech.TrisotechDMNProfile;
import org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory;

@RunWith(value=Parameterized.class)
public class DMN14ExpressionsTest {
    private DMNRuntime runtime;
    private DMNModel model;
    private TestStrategy testConfig;

    @Parameterized.Parameters(name="{0}")
    public static Object[] params() {
        return new Object[]{TestStrategy.KIE_API, TestStrategy.DMNRUNTIMEBUILDER};
    }

    public DMNRuntime createRuntime(String model, Class<?> class1) {
        if (this.testConfig == TestStrategy.DMNRUNTIMEBUILDER) {
            return this.createRuntimeUsingBuilder(model, class1);
        }
        return this.createRuntimeUsingKieAPI(model, class1);
    }

    public DMNRuntime createRuntimeUsingKieAPI(String model, Class<?> class1) {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "dmn-test-" + UUID.randomUUID(), "1.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource modelResource = ks.getResources().newClassPathResource(model, class1);
        kfs.write(modelResource);
        kfs.writeKModuleXML("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <configuration>\n    <property key=\"org.kie.dmn.profiles.trisotech\" value=\"org.kie.dmn.trisotech.TrisotechDMNProfile\"/>\n    <property key=\"org.kie.dmn.decisionlogiccompilerfactory\" value=\"org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory\"/>\n  </configuration>\n</kmodule>");
        kfs.generateAndWritePomXML(releaseId);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        ((ListAssert)Assertions.assertThat((List)kieBuilder.getResults().getMessages()).as(kieBuilder.getResults().getMessages().toString(), new Object[0])).isEmpty();
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        DMNRuntime runtime = DMNRuntimeUtil.typeSafeGetKieRuntime((KieContainer)kieContainer);
        return runtime;
    }

    public DMNRuntime createRuntimeUsingBuilder(String model, Class<?> class1) {
        return (DMNRuntime)DMNRuntimeBuilder.fromDefaults().addProfile((DMNProfile)new TrisotechDMNProfile()).setDecisionLogicCompilerFactory((DMNDecisionLogicCompilerFactory)new TrisotechDMNEvaluatorCompilerFactory()).buildConfiguration().fromClasspathResource(model, class1).getOrElseThrow(e -> new RuntimeException("Error initalizing DMNRuntime", (Throwable)e));
    }

    public DMN14ExpressionsTest(TestStrategy testConfig) {
        this.testConfig = testConfig;
    }

    @Before
    public void setup() {
        this.runtime = this.createRuntime("dmn14expressions.dmn", DMN14ExpressionsTest.class);
        Assertions.assertThat((Object)this.runtime).isNotNull();
        this.model = this.runtime.getModel("http://www.trisotech.com/definitions/_3404349f-5046-4ad3-ad15-7f1e27291ab5", "DMN 1.4 expressions");
        Assertions.assertThat((Object)this.model).isNotNull();
    }

    @Test
    public void testConditionalWithInput() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", true)), new String[]{"Conditional"});
        Assertions.assertThat((Object)results.getDecisionResultByName("Conditional").getResult()).isEqualTo((Object)"Conditional evaluated to TRUE");
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", false)), new String[]{"Conditional"});
        Assertions.assertThat((Object)results.getDecisionResultByName("Conditional").getResult()).isEqualTo((Object)"Conditional evaluated to FALSE");
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Boolean Input", null)), new String[]{"Conditional"});
        Assertions.assertThat((Object)results.getDecisionResultByName("Conditional").getResult()).isEqualTo((Object)"Conditional evaluated to FALSE");
    }

    @Test
    public void testConditionalNonBooleanIf() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(), new String[]{"Non boolean"});
        Assertions.assertThat((List)results.getMessages()).hasSize(1);
        Assertions.assertThat((Comparable)((DMNMessage)results.getMessages().iterator().next()).getMessageType()).isEqualTo((Object)DMNMessageType.ERROR_EVAL_NODE);
    }

    @Test
    public void testIteratorFor() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition").getResult().toString()).isEqualTo(Arrays.asList(2, 3, 4, 5).toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition").getResult().toString()).isEqualTo(Arrays.asList(3, 4, 5, 6).toString());
    }

    @Test
    public void testIteratorForPartial() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 0)), new String[]{"Addition Partial"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Partial").getResult().toString()).isEqualTo(Arrays.asList(1, 3, 6, 10).toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Addition Partial"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Partial").getResult().toString()).isEqualTo(Arrays.asList(1, 8, 16, 25).toString());
    }

    @Test
    public void testIteratorForInRangeClose() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition Range Close"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Range Close").getResult().toString()).isEqualTo(Arrays.asList(3, 4).toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition Range Close"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Range Close").getResult().toString()).isEqualTo(Arrays.asList(4, 5).toString());
    }

    @Test
    public void testIteratorForInRangeOpen() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 1)), new String[]{"Addition Range Open"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Range Open").getResult().toString()).isEqualTo(Arrays.asList(2, 3, 4, 5).toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 2)), new String[]{"Addition Range Open"});
        Assertions.assertThat((String)results.getDecisionResultByName("Addition Range Open").getResult().toString()).isEqualTo(Arrays.asList(3, 4, 5, 6).toString());
    }

    @Test
    public void testIteratorSome() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Number Greater Exists"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult())).isTrue();
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -1)), new String[]{"Number Greater Exists"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult())).isTrue();
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"Number Greater Exists"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("Number Greater Exists").getResult())).isFalse();
    }

    @Test
    public void testIteratorEvery() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"All Greater"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult())).isFalse();
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -1)), new String[]{"All Greater"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult())).isTrue();
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"All Greater"});
        Assertions.assertThat((boolean)((Boolean)results.getDecisionResultByName("All Greater").getResult())).isFalse();
    }

    @Test
    public void testFilterIndex() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Match by index"});
        Assertions.assertThat((Object)results.getDecisionResultByName("Match by index").getResult()).isEqualTo((Object)new BigDecimal(5));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", -2)), new String[]{"Match by index"});
        Assertions.assertThat((Object)results.getDecisionResultByName("Match by index").getResult()).isEqualTo((Object)new BigDecimal(9));
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 0)), new String[]{"Match by index"});
        Assertions.assertThat((List)results.getMessages()).hasSizeGreaterThan(0);
    }

    @Test
    public void testFilterExpression() throws Throwable {
        DMNResult results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 5)), new String[]{"Match by Fnct"});
        Assertions.assertThat((String)results.getDecisionResultByName("Match by Fnct").getResult().toString()).isEqualTo(Arrays.asList(6, 7, 8, 9, 10).toString());
        results = this.runtime.evaluateByName(this.model, (DMNContext)new DMNContextImpl(Collections.singletonMap("Number Input", 11)), new String[]{"Match by Fnct"});
        Assertions.assertThat((String)results.getDecisionResultByName("Match by Fnct").getResult().toString()).isEqualTo(List.of().toString());
    }

    public static enum TestStrategy {
        KIE_API,
        DMNRUNTIMEBUILDER;

    }
}

