/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.trisotech.validation;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.trisotech.TrisotechDMNProfile;
import org.kie.dmn.trisotech.core.compiler.TrisotechDMNEvaluatorCompilerFactory;
import org.kie.dmn.trisotech.validation.TrisotechSchema;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;

public class TrisotechValidationTest {
    protected static DMNValidator validator;
    protected static DMNMarshaller marshaller;

    @BeforeClass
    public static void init() {
        List<TrisotechDMNProfile> dmnProfiles = List.of(new TrisotechDMNProfile());
        Properties p = new Properties();
        p.put("org.kie.dmn.decisionlogiccompilerfactory", TrisotechDMNEvaluatorCompilerFactory.class.getCanonicalName());
        validator = DMNValidatorFactory.newValidator(dmnProfiles, (Properties)p);
    }

    @AfterClass
    public static void dispose() {
        validator.dispose();
    }

    protected Reader getReader(String resourceFileName) {
        return this.getReader(resourceFileName, this.getClass());
    }

    protected Reader getReader(String resourceFileName, Class<?> clazz) {
        return new InputStreamReader(clazz.getResourceAsStream(resourceFileName));
    }

    @Test
    public void testBoxedExtension_Conditional13() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingSchema(TrisotechSchema.INSTANCEv1_3).theseModels(new Reader[]{this.getReader("boxedcontextextension/conditional.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    public void testBoxedExtension_Iterator13() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingSchema(TrisotechSchema.INSTANCEv1_3).theseModels(new Reader[]{this.getReader("boxedcontextextension/iterator.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    public void testBoxedExtension_IteratorDataType13() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingSchema(TrisotechSchema.INSTANCEv1_3).theseModels(new Reader[]{this.getReader("boxedcontextextension/iterator-datatype.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    public void testBoxedExtension_Filter13() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingSchema(TrisotechSchema.INSTANCEv1_3).theseModels(new Reader[]{this.getReader("boxedcontextextension/filter.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }

    @Test
    public void testBoxedExtension_FilterDataType13() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).usingSchema(TrisotechSchema.INSTANCEv1_3).theseModels(new Reader[]{this.getReader("boxedcontextextension/filter-datatype.dmn")});
        Assertions.assertThat((List)validate).hasSize(0);
    }
}

