/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDMNDITest
extends AbstractValidatorTest {
    @Test
    public void testAllElements() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void testMISSING_DMNSHAPE_MISSING_DMNEDGE() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements-with-dmndi-no-dmnshape.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)12));
            Assert.assertThat((Object)validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.DMNDI_MISSING_DIAGRAM)).count(), (Matcher)CoreMatchers.is((Object)12L));
        }
    }

    @Test
    public void testUNKNOWN_REF() throws IOException {
        try (Reader reader = this.getReader("dmndi/all-elements-invalid-ref.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)24));
            Assert.assertThat((Object)validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.DMNDI_MISSING_DIAGRAM)).count(), (Matcher)CoreMatchers.is((Object)12L));
            Assert.assertThat((Object)validate.stream().filter(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.DMNDI_UNKNOWN_REF)).count(), (Matcher)CoreMatchers.is((Object)12L));
        }
    }
}

