/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class MisleadingRulesTest
extends AbstractDTAnalysisTest {
    @Test
    public void testMisleadingRules() {
        List validate = validator.validate(this.getReader("MisleadingRules.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = MisleadingRulesTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)1));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(4, 2), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(false), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.OPEN, null)), Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"M"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"M"), Range.RangeBoundary.CLOSED, null))))));
        Assert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        Assert.assertThat((Object)analysis.getMisleadingRules(), (Matcher)Matchers.hasSize((int)1));
        List<MisleadingRule> misleadingRules = Arrays.asList(new MisleadingRule(4, 2));
        Assert.assertThat(misleadingRules, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)analysis.getMisleadingRules(), (Matcher)Matchers.contains((Object[])misleadingRules.toArray()));
        Assert.assertTrue((String)"It should contain at least 1 DMNMessage for the MisleadingRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE)));
        Assert.assertTrue((String)"This test case is not a Masked rule example", (boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
    }
}

