/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class OverlapsMsgTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("improveHF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = OverlapsMsgTest.getAnalysis(validate, "_CA4B40F8-2354-48B6-B323-5C4E4B2CE467");
        Assert.assertThat((Object)analysis.getGaps(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.hasSize((int)2));
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(3, 1), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null))))), new Overlap(Arrays.asList(2, 3), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)new BigDecimal("47"), Range.RangeBoundary.OPEN, null), (Bound)new Bound(Interval.POS_INF, Range.RangeBoundary.CLOSED, null)), Interval.newFromBounds((Bound)new Bound(Interval.NEG_INF, Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)new BigDecimal("0"), Range.RangeBoundary.CLOSED, null))))));
        Assert.assertThat(overlaps, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)analysis.getOverlaps(), (Matcher)Matchers.contains((Object[])overlaps.toArray()));
        Assert.assertThat((Object)((Overlap)analysis.getOverlaps().get(0)).getOverlap().asHumanFriendly(analysis.getDdtaTable()), (Matcher)Matchers.is((Object)"[ -, >0 ]"));
        Assert.assertThat((Object)((Overlap)analysis.getOverlaps().get(1)).getOverlap().asHumanFriendly(analysis.getDdtaTable()), (Matcher)Matchers.is((Object)"[ >47, <=0 ]"));
    }
}

