/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorDecisionTableTest
extends AbstractValidatorTest {
    @Test
    public void testDTABLE_EMPTY_ENTRY_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_EMPTY_ENTRY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        }
    }

    @Test
    public void testDTABLE_EMPTY_ENTRY_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_EMPTY_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testDTABLE_EMPTY_ENTRY_DefintionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_EMPTY_ENTRY.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_MISSING_OUTVALS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)5));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME)));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
        }
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testDTABLE_MULTIPLEOUT_NAME_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_MULTIPLEOUTPUT_WRONG_OUTPUT"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_PRIORITY_MISSING_OUTVALS.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES)));
        }
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_PRIORITY_MISSING_OUTVALS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES)));
    }

    @Test
    public void testDTABLE_PRIORITY_MISSING_OUTVALS_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_PRIORITY_MISSING_OUTVALS.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_PRIORITY_MISSING_OUTVALS"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_OUTPUT_VALUES)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME)));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF)));
        }
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME_FileInput() {
        List validate = validator.validate(this.getFile("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF)));
    }

    @Test
    public void testDTABLE_SINGLEOUT_NONAME_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("DTABLE_SINGLEOUTPUT_WRONG_OUTPUT.dmn", "https://github.com/kiegroup/kie-dmn", "DTABLE_SINGLEOUTPUT_WRONG_OUTPUT"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        MatcherAssert.assertThat((String)ValidatorUtil.formatMessages((List)validate), (Object)validate.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ILLEGAL_USE_OF_TYPEREF)));
    }
}

