/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class Check1stNFViolationTest
extends AbstractDTAnalysisTest {
    @Test
    public void testCheck1stNFViolation() {
        List validate = validator.validate(this.getReader("DT1stNFViolation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = Check1stNFViolationTest.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        MatcherAssert.assertThat((Object)analysisDuplicate.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.contains((Object[])Collections.singletonList(Arrays.asList(1, 2)).toArray()));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
        DTAnalysis analysisFIRST = Check1stNFViolationTest.getAnalysis(validate, "_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d");
        MatcherAssert.assertThat((Object)analysisFIRST.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_1ca6acde-c1d4-4c50-8e21-f3b11e106f3d") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
        DTAnalysis analysisRULE_ORDER = Check1stNFViolationTest.getAnalysis(validate, "_03522945-b520-4b45-ac5e-ef3cbd7f1eaf");
        MatcherAssert.assertThat((Object)analysisRULE_ORDER.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_03522945-b520-4b45-ac5e-ef3cbd7f1eaf") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
    }

    @Test
    public void testCheck1stNFViolationB() {
        List validate = validator.validate(this.getReader("DT1stNFViolationB.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysisDuplicate = Check1stNFViolationTest.getAnalysis(validate, "_053034d5-0e1f-4c4a-8513-ab3c6ba538db");
        MatcherAssert.assertThat((Object)analysisDuplicate.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysisDuplicate.getDuplicateRulesTuples(), (Matcher)Matchers.contains((Object[])Collections.singletonList(Arrays.asList(1, 2)).toArray()));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getSourceId().equals("_053034d5-0e1f-4c4a-8513-ab3c6ba538db") && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
    }

    @Test
    public void testCheck1stNFViolationDuplicateNoSubsumption() {
        List validate = validator.validate(this.getReader("DT1stNFViolationDuplicateNoSubsumption.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = Check1stNFViolationTest.getAnalysis(validate, "_221BF4A4-F8D4-466C-96E4-311FE3C9867B");
        MatcherAssert.assertThat((Object)analysis.is1stNFViolation(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)analysis.getDuplicateRulesTuples(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)analysis.getDuplicateRulesTuples(), (Matcher)Matchers.contains((Object[])Collections.singletonList(Arrays.asList(1, 2)).toArray()));
        Assert.assertTrue((String)"It should contain at DMNMessage for the 1st NF Violation", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_1STNFVIOLATION)));
        MatcherAssert.assertThat((Object)analysis.getSubsumptions().isEmpty(), (Matcher)Matchers.is((Object)false));
        Assert.assertTrue((String)"No message about subsumption", (boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_SUBSUMPTION_RULE)));
    }
}

