/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorContextTest
extends AbstractValidatorTest {
    @Test
    public void testCONTEXT_MISSING_EXPR_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_MISSING_EXPR.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        }
    }

    @Test
    public void testCONTEXT_MISSING_EXPR_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_MISSING_EXPR_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_MISSING_EXPR.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_MISSING_ENTRIES_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_MISSING_ENTRIES.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        }
    }

    @Test
    public void testCONTEXT_MISSING_ENTRIES_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_MISSING_ENTRIES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_MISSING_ENTRIES_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_MISSING_ENTRIES.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testCONTEXT_ENTRY_MISSING_VARIABLE_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
            ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
            Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
        }
    }

    @Test
    public void testCONTEXT_ENTRY_MISSING_VARIABLE_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
        Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
    }

    @Test
    public void testCONTEXT_ENTRY_MISSING_VARIABLE_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_ENTRY_MISSING_VARIABLE.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_MISSING_EXPR"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_VARIABLE)));
        ContextEntry ce = (ContextEntry)((DMNMessage)validate.get(0)).getSourceReference();
        Assertions.assertThat((int)((Context)ce.getParent()).getContextEntry().indexOf(ce)).isEqualTo(1);
    }

    @Test
    public void testCONTEXT_DUP_ENTRY_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_DUP_ENTRY.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
        }
    }

    @Test
    public void testCONTEXT_DUP_ENTRY_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_DUP_ENTRY.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
    }

    @Test
    public void testCONTEXT_DUP_ENTRY_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_DUP_ENTRY.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_DUP_ENTRY"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
    }

    @Test
    public void testCONTEXT_ENTRY_NOTYPEREF_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("context/CONTEXT_ENTRY_NOTYPEREF.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
            Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        }
    }

    @Test
    public void testCONTEXT_ENTRY_NOTYPEREF_FileInput() {
        List validate = validator.validate(this.getFile("context/CONTEXT_ENTRY_NOTYPEREF.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
    }

    @Test
    public void testCONTEXT_ENTRY_NOTYPEREF_DefinitionsInput() {
        List validate = validator.validate(this.getDefinitions("context/CONTEXT_ENTRY_NOTYPEREF.dmn", "https://github.com/kiegroup/kie-dmn", "CONTEXT_ENTRY_NOTYPEREF"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
    }
}

