/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorDMN14Test
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorDMN14Test.class);

    @Test
    public void testSimple_ReaderInput() throws IOException {
        try (Reader reader = this.getReader("dmn14simple.dmn");){
            List validate = validator.validate(reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            Assert.assertEquals((long)0L, (long)validate.size());
        }
    }

    @Test
    public void testSimple_FileInput() {
        List validate = validator.validate(this.getFile("dmn14simple.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testSimple_DefintionsInput() {
        List validate = validator.validate(this.getDefinitions("dmn14simple.dmn", "http://www.trisotech.com/definitions/_d9232146-7aaa-49a9-8668-261a01844ace", "Drawing 1"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testBoxedExtension_Conditional14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/conditional.dmn")});
        LOG.debug("{}", (Object)validate);
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testBoxedExtension_Iterator14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/iterator.dmn")});
        LOG.debug("{}", (Object)validate);
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testBoxedExtension_IteratorDataType14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/iterator-datatype.dmn")});
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testBoxedExtension_Filter14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/filter.dmn")});
        Assert.assertEquals((long)0L, (long)validate.size());
    }

    @Test
    public void testBoxedExtension_FilterDataType14() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("dmn14boxed/filter-datatype.dmn")});
        Assert.assertEquals((long)0L, (long)validate.size());
    }
}

