/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.DMNRuntimeTest;
import org.kie.dmn.core.decisionservices.DMNDecisionServicesTest;
import org.kie.dmn.core.imports.ImportsTest;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.v1_3.DMN13specificTest;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.validation.ValidatorUtil;

public class ValidatorTest
extends AbstractValidatorTest {
    @Test
    public void testDryRun() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"0001-input-data-string.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn", "_0001-input-data-string");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        DMNValidatorFactory.newValidator().validate(definitions);
    }

    @Test
    public void testMACDInputDefinitions() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"MACD-enhanced_iteration.dmn", DMNInputRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/definitions/_6cfe7d88-6741-45d1-968c-b61a597d0964", "MACD-enhanced iteration");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).as(messages.toString(), new Object[0])).hasSize(0);
    }

    @Test
    public void testMACDInputReader() throws IOException {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/org/kie/dmn/core/MACD-enhanced_iteration.dmn"));){
            List messages = DMNValidatorFactory.newValidator().validate((Reader)reader, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
            ((ListAssert)Assertions.assertThat((List)messages).withFailMessage(messages.toString(), new Object[0])).hasSize(0);
        }
    }

    private Definitions utilDefinitions(String filename, String modelName) {
        Definitions definitions;
        DMNMarshaller marshaller = DMNMarshallerFactory.newDefaultMarshaller();
        InputStreamReader isr = new InputStreamReader(this.getClass().getResourceAsStream(filename));
        try {
            Definitions definitions2 = marshaller.unmarshal((Reader)isr);
            Assertions.assertThat((Object)definitions2).isNotNull();
            definitions = definitions2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)"Unable for the test suite to locate the file for validation.");
                return null;
            }
        }
        isr.close();
        return definitions;
    }

    @Test
    public void testInvalidXml() throws URISyntaxException {
        List validateXML = validator.validate(new File(this.getClass().getResource("invalidXml.dmn").toURI()), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA});
        ((ListAssert)Assertions.assertThat((List)validateXML).withFailMessage(ValidatorUtil.formatMessages((List)validateXML), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validateXML.get(0)).getMessageType()).withFailMessage(((DMNMessage)validateXML.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.FAILED_XML_VALIDATION);
        Assertions.assertThat((String)((DMNMessage)validateXML.get(0)).getPath()).contains(new CharSequence[]{"invalidXml.dmn"});
    }

    @Test
    public void testINVOCATION_MISSING_EXPR() {
        List validate = validator.validate(this.getReader("INVOCATION_MISSING_EXPR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validate.get(0)).getMessageType()).withFailMessage(((DMNMessage)validate.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.MISSING_EXPRESSION);
    }

    @Test
    public void testNAME_IS_VALID() {
        List validate = validator.validate(this.getReader("NAME_IS_VALID.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testNAME_INVALID_empty_name() {
        List validate = validator.validate(this.getReader("DROOLS-1447.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(4);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.FAILED_XML_VALIDATION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.VARIABLE_NAME_MISMATCH)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_5e43b55c-888e-443c-b1b9-80e4aa6746bd")));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_b1e4588e-9ce1-4474-8e4e-48dbcdb7524b")));
    }

    @Test
    public void testDRGELEM_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("DRGELEM_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME)));
    }

    @Test
    public void testFORMAL_PARAM_DUPLICATED() {
        List validate = validator.validate(this.getReader("FORMAL_PARAM_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(3);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_PARAM)));
    }

    @Test
    public void testINVOCATION_INCONSISTENT_PARAM_NAMES() {
        List validate = validator.validate(this.getReader("INVOCATION_INCONSISTENT_PARAM_NAMES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH)));
    }

    @Test
    @Ignore(value="Needs to be improved as invocations can be used to invoke functions node defined in BKMs. E.g., FEEL built in functions, etc.")
    public void testINVOCATION_MISSING_TARGET() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGET.dmn", "INVOCATION_MISSING_TARGET");
        List validate = validator.validate(definitions);
    }

    @Ignore(value="known current limitation")
    @Test
    public void testINVOCATION_MISSING_TARGETRbis() {
        Definitions definitions = this.utilDefinitions("INVOCATION_MISSING_TARGETbis.dmn", "INVOCATION_MISSING_TARGETbis");
        List validate = validator.validate(definitions);
    }

    @Test
    public void testINVOCATION_WRONG_PARAM_COUNT() {
        List validate = validator.validate(this.getReader("INVOCATION_WRONG_PARAM_COUNT.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.PARAMETER_MISMATCH)));
    }

    @Test
    public void testITEMCOMP_DUPLICATED() {
        List validate = validator.validate(this.getReader("ITEMCOMP_DUPLICATED.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_ITEM_DEF)));
    }

    @Test
    public void testITEMDEF_NOT_UNIQUE_DROOLS_1450() {
        List validate = validator.validate(this.getReader("ITEMDEF_NOT_UNIQUE_DROOLS-1450.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testRELATION_DUP_COLUMN() {
        List validate = validator.validate(this.getReader("RELATION_DUP_COLUMN.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DUPLICATED_RELATION_COLUMN)));
    }

    @Test
    public void testRELATION_ROW_CELL_NOTLITERAL() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELL_NOTLITERAL.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_NOT_LITERAL)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
    }

    @Test
    public void testRELATION_ROW_CELLCOUNTMISMATCH() {
        List validate = validator.validate(this.getReader("RELATION_ROW_CELLCOUNTMISMATCH.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.RELATION_CELL_COUNT_MISMATCH)));
    }

    @Test
    public void testMortgageRecommender() {
        List validate = validator.validate(this.getReader("MortgageRecommender.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)validate.isEmpty()).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).isFalse();
    }

    @Test
    public void testREQAUTH_NOT_KNOWLEDGESOURCEbis() {
        List validate = validator.validate(this.getReader("REQAUTH_NOT_KNOWLEDGESOURCEbis.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
    }

    @Test
    public void testVARIABLE_LEADING_TRAILING_SPACES() {
        List validate = validator.validate(this.getReader("VARIABLE_LEADING_TRAILING_SPACES.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
        Assertions.assertThat((String)((DMNMessage)validate.get(0)).getSourceId()).isEqualTo("_dd662d27-7896-42cb-9d14-bd74203bdbec");
    }

    @Test
    public void testUNKNOWN_VARIABLE() {
        List validate = validator.validate(this.getReader("UNKNOWN_VARIABLE.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)));
    }

    @Test
    public void testUNKNOWN_OPERATOR() {
        List validate = validator.validate(this.getReader("UNKNOWN_OPERATOR.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSizeGreaterThan(0);
    }

    @Test
    public void testVALIDATION() {
        List validate = validator.validate(this.getReader("validation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(5);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL)));
    }

    @Test
    public void testUsingSemanticNamespacePrefix() {
        List validate = validator.validate(this.getReader("UsingSemanticNS.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testUsingSemanticNamespacePrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_semantic_namespace_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testNoPrefixAndExtensions() {
        List validate = validator.validate(this.getReader("Hello_World_no_prefix_with_extensions.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testRelationwithemptycell() {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)"relation_with_empty_cell.dmn", DMNRuntimeTest.class);
        DMNModel dmnModel = runtime.getModel("http://www.trisotech.com/dmn/definitions/_99a00903-2943-47df-bab1-a32f276617ea", "Relation with empty cell");
        Assertions.assertThat((Object)dmnModel).isNotNull();
        Definitions definitions = dmnModel.getDefinitions();
        Assertions.assertThat((Object)dmnModel).isNotNull();
        List messages = DMNValidatorFactory.newValidator().validate(definitions, new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)messages).withFailMessage(messages.toString(), new Object[0])).hasSize(0);
    }

    @Test
    public void testRelationwithemptycellJustValidator() {
        List validate = validator.validate(this.getReader("relation_with_empty_cell.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testBoxedInvocationMissingExpression() {
        List validate = validator.validate(this.getReader("DROOLS-2813-NPE-BoxedInvocationMissingExpression.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_a111c4df-c5b5-4d84-81e7-3ec735b50d06")));
    }

    @Test
    public void testDMNv1_2_ch11Modified() {
        List validate = validator.validate(this.getReader("v1_2/ch11MODIFIED.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDMNv1_2_ch11() {
        List validate = validator.validate(this.getReader("DMNv12_ch11.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF)));
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("d_Adjudication")));
    }

    @Test
    public void testDecisionServiceCompiler20180830() {
        List validate = validator.validate(this.getReader("DecisionServiceABC.dmn", DMNDecisionServicesTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDecisionServiceCompiler20180830DMNV12() {
        List validate = validator.validate(this.getReader("DecisionServiceABC_DMN12.dmn", org.kie.dmn.core.v1_2.DMNDecisionServicesTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.MISSING_TYPE_REF) && p.getSourceId().equals("_63d05cff-8e3b-4dad-a355-fd88f8bcd613")));
    }

    @Test
    public void testDecisionService20181008() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
        List missingDMNImport = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("DSWithImport20181008-ModelA.dmn"), this.getReader("DSWithImport20181008-ModelB-missingDMNImport.dmn")});
        Assertions.assertThat(missingDMNImport.stream().filter(p -> p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).hasSize(2);
    }

    @Test
    public void testInvalidFunctionNameInvocation() {
        List validate = validator.validate(this.getReader("invalidFunctionNameInvocation.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assertions.assertThat(validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.REQ_NOT_FOUND))).hasSize(1);
    }

    @Test
    public void testDecisionNoExpr() {
        List validate = validator.validate(this.getReader("noExpr.dmn", DMNRuntimeTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assertions.assertThat(validate.stream().filter(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_cdd03786-d1ab-47b5-ba05-df830458dc62"))).hasSize(1);
    }

    @Test
    public void testValidateSchemaAndModels() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Reader[]{this.getReader("base join.dmn", ImportsTest.class), this.getReader("use join.dmn", ImportsTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDMNv1_3_simple() {
        List validate = validator.validate(this.getReader("simple.dmn", DMN13specificTest.class), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void testDMNv1_3_ch11example1() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("Financial.dmn", DMN13specificTest.class), this.getReader("Chapter 11 Example.dmn", DMN13specificTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.MISSING_EXPRESSION) && p.getSourceId().equals("_4bd33d4a-741b-444a-968b-64e1841211e7")));
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.INVALID_NAME) && p.getSourceId().equals("_96b30012-a6e7-4545-89d3-068ec722469c")));
    }

    @Test
    public void testSomethingInBetweenOC() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("somethingInBetween.dmn")});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.ERROR && p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL) && p.getSourceId().equals("_841ed91c-db69-401e-890b-08a5bf44222d")));
    }

    @Test
    public void testDMNv1_3_ch11example2() {
        List validate = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Reader[]{this.getReader("Recommended Loan Products.dmn", DMN13specificTest.class), this.getReader("Loan info.dmn", DMN13specificTest.class)});
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(0);
    }

    @Test
    public void test_dttyperef() {
        List validate = validator.validate(this.getReader("wrongxml/dttyperef.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        ((ListAssert)Assertions.assertThat((List)validate).as(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(1);
        DMNMessage v0 = (DMNMessage)validate.get(0);
        Assertions.assertThat((Comparable)v0.getLevel()).isEqualTo((Object)Message.Level.ERROR);
        Assertions.assertThat((Comparable)v0.getMessageType()).isEqualTo((Object)DMNMessageType.MISSING_TYPE_REF);
        Assertions.assertThat((String)v0.getSourceId()).isEqualTo("_99FC159F-0D94-45C3-A9BD-F1388017A5D4");
    }

    @Test
    public void testBkmAndBindingWarnLevel() {
        List validate = validator.validate(this.getReader("bkmAndBinding.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().allMatch(p -> p.getLevel() == Message.Level.WARNING));
        ((ListAssert)Assertions.assertThat((List)validate).withFailMessage(ValidatorUtil.formatMessages((List)validate), new Object[0])).hasSize(2);
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getSourceId() != null && p.getSourceId().equals("_3ce3c41a-450a-40d1-9e9c-09180cd29879")));
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().anyMatch(p -> p.getLevel() == Message.Level.WARNING && ((DMNElement)((DMNModelInstrumentedBase)p.getSourceReference()).getParent()).getId().equals("_d8b0c243-3fb6-40ec-a29c-28f8bdb92e13")));
    }

    @Test
    public void testInformationItemMissingTypeRef_SC() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_COMPILATION);
    }

    @Test
    public void testInformationItemMissingTypeRef_SM() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Test
    public void testInformationItemMissingTypeRef_SMC() {
        this.checkInformationItemMissingTypeRef(DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION);
    }

    private void checkInformationItemMissingTypeRef(DMNValidator.Validation ... options) {
        List validate = validator.validate(this.getReader("variableMissingTypeRef.dmn"), options);
        Assert.assertTrue((String)ValidatorUtil.formatMessages((List)validate), (boolean)validate.stream().allMatch(p -> p.getLevel() == Message.Level.WARNING && p.getSourceId().equals("_FE47213A-2042-49DE-9A44-65831DA6AD11")));
    }
}

