/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.dmn.validation.dtanalysis.model.Hyperrectangle;
import org.kie.dmn.validation.dtanalysis.model.Interval;
import org.kie.dmn.validation.dtanalysis.model.MisleadingRule;
import org.kie.dmn.validation.dtanalysis.model.Overlap;

public class MisleadingRulesTest
extends AbstractDTAnalysisTest {
    @Test
    public void testMisleadingRules() {
        List validate = validator.validate(this.getReader("MisleadingRules.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = MisleadingRulesTest.getAnalysis(validate, "_BA703D04-803A-44AA-8A31-F5EEDD4FD54E");
        Assertions.assertThat((Iterable)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis.getOverlaps()).hasSize(1);
        List<Overlap> overlaps = Arrays.asList(new Overlap(Arrays.asList(4, 2), new Hyperrectangle(2, Arrays.asList(Interval.newFromBounds((Bound)new Bound((Comparable)Boolean.valueOf(false), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)Boolean.valueOf(true), Range.RangeBoundary.OPEN, null)), Interval.newFromBounds((Bound)new Bound((Comparable)((Object)"M"), Range.RangeBoundary.CLOSED, null), (Bound)new Bound((Comparable)((Object)"M"), Range.RangeBoundary.CLOSED, null))))));
        Assertions.assertThat(overlaps).hasSize(1);
        Assertions.assertThat((List)analysis.getOverlaps()).containsAll(overlaps);
        Assertions.assertThat((Iterable)analysis.getMisleadingRules()).hasSize(1);
        List<MisleadingRule> misleadingRules = Arrays.asList(new MisleadingRule(4, 2));
        Assertions.assertThat(misleadingRules).hasSize(1);
        Assertions.assertThat((Iterable)analysis.getMisleadingRules()).containsAll(misleadingRules);
        Assert.assertTrue((String)"It should contain at least 1 DMNMessage for the MisleadingRule", (boolean)validate.stream().anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MISLEADING_RULE)));
        Assert.assertTrue((String)"This test case is not a Masked rule example", (boolean)validate.stream().noneMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_MASKED_RULE)));
    }

    @Test
    public void testMisleadingRules2() {
        List validate = validator.validate(this.getReader("MisleadingRules2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis = MisleadingRulesTest.getAnalysis(validate, "_0cffdf05-071b-423b-94b9-182c2cc2435c");
        Assertions.assertThat((Iterable)analysis.getGaps()).hasSize(0);
        Assertions.assertThat((Iterable)analysis.getMisleadingRules()).hasSize(0);
    }
}

