/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;

public abstract class AbstractValidatorTest {
    protected static DMNValidator validator;

    @BeforeClass
    public static void init() {
        validator = DMNValidatorFactory.newValidator();
    }

    @AfterClass
    public static void dispose() {
        validator.dispose();
    }

    protected Reader getReader(String resourceFileName) {
        return this.getReader(resourceFileName, this.getClass());
    }

    protected Reader getReader(String resourceFileName, Class<?> clazz) {
        return new InputStreamReader(clazz.getResourceAsStream(resourceFileName));
    }

    protected File getFile(String resourceFileName) {
        return new File(this.getClass().getResource(resourceFileName).getFile());
    }

    protected Definitions getDefinitions(String resourceName, String namespace, String modelName) {
        DMNRuntime runtime = DMNRuntimeUtil.createRuntime((String)resourceName, this.getClass());
        DMNModel dmnModel = runtime.getModel(namespace, modelName);
        Assert.assertThat((Object)dmnModel, (Matcher)CoreMatchers.notNullValue());
        Definitions definitions = dmnModel.getDefinitions();
        Assert.assertThat((Object)definitions, (Matcher)CoreMatchers.notNullValue());
        return definitions;
    }
}

