/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.dtanalysis.AbstractDTAnalysisTest;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;

public class SomeProblemTest
extends AbstractDTAnalysisTest {
    @Test
    public void test() {
        List validate = validator.validate(this.getReader("SomeProblem.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_a36e37f8-aae0-4118-8267-cbb37c7955cb");
        Assertions.assertThat((boolean)analysis1.isError()).isFalse();
        Assertions.assertThat((Iterable)analysis1.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis1.getOverlaps()).hasSize(0);
        DTAnalysis analysis2 = SomeProblemTest.getAnalysis(validate, "_2aea80b4-19fa-4831-8829-4db925a128aa");
        Assertions.assertThat((boolean)analysis2.isError()).isTrue();
    }

    @Test
    public void testLtGtNumber() {
        List validate = validator.validate(this.getReader("problemLtGtNumber.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("Unrecognized unary test: '<> 47'; did you meant to write 'not(47)' instead?"));
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_207A079D-3C86-48D9-AE18-40D9485514F3");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    @Test
    public void testGtLtString() {
        List validate = validator.validate(this.getReader("problemGtLtString.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("Unrecognized unary test: '><\"a\"'; did you meant to write 'not(\"a\")' instead?"));
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_207A079D-3C86-48D9-AE18-40D9485514F3");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    @Test
    public void testDiseqNumber() {
        List validate = validator.validate(this.getReader("problemDiseqNumber.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("Unrecognized unary test: '!= 47'; did you meant to write 'not(47)' instead?"));
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_B390752D-2181-40AF-A42C-737B3009DBAB");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    @Test
    public void testDiseqString() {
        List validate = validator.validate(this.getReader("problemDiseqString.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).anyMatch(p -> p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("Unrecognized unary test: '!=\"a\"'; did you meant to write 'not(\"a\")' instead?"));
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_B390752D-2181-40AF-A42C-737B3009DBAB");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    @Test
    public void testValidDiseqNumber1() {
        List validate = validator.validate(this.getReader("validDiseqNumber1.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).anyMatch(p -> p.getLevel() == Message.Level.WARNING && p.getMessageType().equals((Object)DMNMessageType.DECISION_TABLE_ANALYSIS_ERROR) && p.getText().contains("Unmanaged unary test: '? != 47'; you could write 'not(47)' instead."));
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_C72B227B-AF0C-4BC4-9E3F-CD44F842C886");
        Assertions.assertThat((boolean)analysis1.isError()).isTrue();
    }

    @Test
    public void testValidDiseqNumber2() {
        List validate = validator.validate(this.getReader("validDiseqNumber2.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        Assertions.assertThat((List)validate).noneMatch(p -> p.getLevel() == Message.Level.ERROR || p.getLevel() == Message.Level.WARNING);
        DTAnalysis analysis1 = SomeProblemTest.getAnalysis(validate, "_C72B227B-AF0C-4BC4-9E3F-CD44F842C886");
        Assertions.assertThat((boolean)analysis1.isError()).isFalse();
        Assertions.assertThat((Iterable)analysis1.getGaps()).hasSize(0);
        Assertions.assertThat((List)analysis1.getOverlaps()).hasSize(0);
    }
}

