/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.core.DMNInputRuntimeTest;
import org.kie.dmn.core.decisionservices.DMNDecisionServicesTest;
import org.kie.dmn.validation.AbstractValidatorTest;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.ValidatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsingResourceValidatorTest
extends AbstractValidatorTest {
    private static final Logger LOG = LoggerFactory.getLogger(UsingResourceValidatorTest.class);

    @Test
    public void testInvalidXml_single() {
        List validateXML = validator.validate(this.getResource("invalidXml.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA});
        ((ListAssert)Assertions.assertThat((List)validateXML).as(ValidatorUtil.formatMessages((List)validateXML), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validateXML.get(0)).getMessageType()).as(((DMNMessage)validateXML.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.FAILED_XML_VALIDATION);
        Assertions.assertThat((String)((DMNMessage)validateXML.get(0)).getPath()).containsSequence(new CharSequence[]{"invalidXml.dmn"});
    }

    @Test
    public void testInvalidXml_builder() {
        List validateXML = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA}).theseModels(new Resource[]{this.getResource("invalidXml.dmn"), this.getResource("0001-input-data-string.dmn", DMNInputRuntimeTest.class)});
        ((ListAssert)Assertions.assertThat((List)validateXML).as(ValidatorUtil.formatMessages((List)validateXML), new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((DMNMessage)validateXML.get(0)).getMessageType()).as(((DMNMessage)validateXML.get(0)).toString(), new Object[0])).isEqualTo((Object)DMNMessageType.FAILED_XML_VALIDATION);
        Assertions.assertThat((String)((DMNMessage)validateXML.get(0)).getPath()).containsSequence(new CharSequence[]{"invalidXml.dmn"});
    }

    @Test
    public void testFailingModelValidation_single() {
        List messages = validator.validate(this.getResource("import/importingMyHelloDSbkmBoxedInvocation_wrongDoubleImportName.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL});
        LOG.debug("{}", (Object)messages);
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getPath().endsWith("importingMyHelloDSbkmBoxedInvocation_wrongDoubleImportName.dmn") && p.getText().contains("myHelloDS") && p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    public void testFailingModelValidation_builder() {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL}).theseModels(new Resource[]{this.getResource("myHelloDS.dmn", DMNDecisionServicesTest.class), this.getResource("import/importingMyHelloDSbkmBoxedInvocation_wrongDoubleImportName.dmn")});
        LOG.debug("{}", (Object)messages);
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getPath().endsWith("importingMyHelloDSbkmBoxedInvocation_wrongDoubleImportName.dmn") && p.getText().contains("myHelloDS") && p.getMessageType().equals((Object)DMNMessageType.DUPLICATE_NAME))).isTrue();
    }

    @Test
    public void testFailingCompilation_single() {
        List messages = validator.validate(this.getResource("invalidFEEL.dmn"), new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION});
        LOG.debug("{}", (Object)messages);
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getPath().endsWith("invalidFEEL.dmn") && p.getText().contains("Error compiling FEEL expression") && p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }

    @Test
    public void testFailingCompilation_builder() {
        List messages = validator.validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_SCHEMA, DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION}).theseModels(new Resource[]{this.getResource("invalidFEEL.dmn")});
        LOG.debug("{}", (Object)messages);
        Assertions.assertThat((boolean)messages.stream().anyMatch(p -> p.getPath().endsWith("invalidFEEL.dmn") && p.getText().contains("Error compiling FEEL expression") && p.getMessageType().equals((Object)DMNMessageType.ERR_COMPILING_FEEL))).isTrue();
    }
}

