/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.xls2dmn.cli;

import java.io.File;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.dmn.xls2dmn.cli.App;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CardApprovalTest {
    private static final Logger LOG = LoggerFactory.getLogger(CardApprovalTest.class);

    private DMNRuntime getDMNRuntimeWithCLI() throws Exception {
        File tempFile = File.createTempFile("xls2dmn", ".dmn");
        new CommandLine((Object)new App()).execute(new String[]{"src/test/resources/Card_approval.xlsx", tempFile.toString()});
        List validate = DMNValidatorFactory.newValidator().validate(tempFile);
        MatcherAssert.assertThat((Object)validate.stream().filter(m -> m.getLevel() == Message.Level.ERROR).count(), (Matcher)CoreMatchers.is((Object)0L));
        Either fromResources = DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newFileResource((File)tempFile)));
        LOG.info("{}", (Object)System.getProperty("java.io.tmpdir"));
        LOG.info("{}", (Object)tempFile);
        DMNRuntime dmnRuntime = (DMNRuntime)fromResources.getOrElseThrow(RuntimeException::new);
        return dmnRuntime;
    }

    @Test
    public void testCLI() throws Exception {
        DMNRuntime dmnRuntime = this.getDMNRuntimeWithCLI();
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        DMNContext dmnContext = dmnRuntime.newContext();
        dmnContext.set("Annual Income", (Object)70);
        dmnContext.set("Assets", (Object)150);
        DMNResult dmnResult = dmnRuntime.evaluateAll(dmnModel, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        MatcherAssert.assertThat((String)DMNRuntimeUtil.formatMessages((List)dmnResult.getMessages()), (Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)dmnResult.getDecisionResultByName("Standard card score").getResult(), (Matcher)CoreMatchers.is((Object)new BigDecimal(562)));
        MatcherAssert.assertThat((Object)dmnResult.getDecisionResultByName("Gold card score").getResult(), (Matcher)CoreMatchers.is((Object)new BigDecimal(468)));
    }
}

