/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.xls2dmn.cli;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);

    public static DMNRuntime getRuntime(Consumer<String[]> command, File outFile, String[] parameters) throws Exception {
        command.accept(parameters);
        return TestUtils.validateRuntime(outFile);
    }

    public static DMNRuntime validateRuntime(File outFile) {
        List validate = DMNValidatorFactory.newValidator().validate(outFile);
        MatcherAssert.assertThat((Object)validate.stream().filter(m -> m.getLevel() == Message.Level.ERROR).count(), (Matcher)CoreMatchers.is((Object)0L));
        Either fromResources = DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Arrays.asList(ResourceFactory.newFileResource((File)outFile)));
        LOG.info("{}", (Object)System.getProperty("java.io.tmpdir"));
        LOG.info("{}", (Object)outFile);
        DMNRuntime dmnRuntime = (DMNRuntime)fromResources.getOrElseThrow(RuntimeException::new);
        return dmnRuntime;
    }
}

