/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.model.codegen.project.KogitoPackageSources;
import org.drools.model.codegen.project.RuleCodegenError;
import org.drools.model.codegen.tool.ExplicitCanonicalModelCompiler;
import org.kie.api.io.Resource;
import org.kie.drl.engine.compilation.model.DecisionTableFileSetResource;
import org.kie.drl.engine.compilation.model.DrlCallableClassesContainer;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoSetResource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlCompilerHelper {
    private static final Logger logger = LoggerFactory.getLogger(DrlCompilerHelper.class);

    private DrlCompilerHelper() {
    }

    public static DrlCallableClassesContainer getDrlCallableClassesContainer(DecisionTableFileSetResource resources, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        throw new KieCompilerServiceException("Not implemented, yet");
    }

    public static DrlCallableClassesContainer getDrlCallableClassesContainer(EfestoSetResource<PackageDescr> resources, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        for (PackageDescr packageDescr : resources.getContent()) {
            DrlCompilerHelper.addPackageDescr(packageDescr, packageDescr.getResource(), packages);
        }
        return DrlCompilerHelper.getDrlCallableClassesContainer(packages, resources.getBasePath(), new KnowledgeBuilderConfigurationImpl(), memoryCompilerClassLoader);
    }

    public static DrlCallableClassesContainer getDrlCallableClassesContainer(DrlFileSetResource resources, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration = new KnowledgeBuilderConfigurationImpl();
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(knowledgeBuilderConfiguration);
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        for (Resource resource : resources.getFileSystemResource()) {
            DrlCompilerHelper.parseAndAdd(drlResourceHandler, resource, packages);
        }
        return DrlCompilerHelper.getDrlCallableClassesContainer(packages, resources.getBasePath(), knowledgeBuilderConfiguration, memoryCompilerClassLoader);
    }

    static DrlCallableClassesContainer getDrlCallableClassesContainer(Map<String, CompositePackageDescr> packages, String basePath, KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        ExplicitCanonicalModelCompiler compiler = ExplicitCanonicalModelCompiler.of(packages.values(), (KnowledgeBuilderConfigurationImpl)knowledgeBuilderConfiguration, KogitoPackageSources::dumpSources);
        compiler.process();
        BuildResultCollector buildResults = compiler.getBuildResults();
        if (buildResults.hasErrors()) {
            for (KnowledgeBuilderResult e : buildResults.getResults(new ResultSeverity[0])) {
                logger.error(e.getMessage(), (Object)e);
            }
            throw new RuleCodegenError(buildResults.getAllResults());
        }
        Collection packageSources = compiler.getPackageSources();
        ArrayList legacyModelFiles = new ArrayList();
        ArrayList<String> generatedRulesModels = new ArrayList<String>();
        for (KogitoPackageSources pkgSources : packageSources) {
            pkgSources.collectGeneratedFiles(legacyModelFiles);
            generatedRulesModels.add(pkgSources.getPackageName() + "." + pkgSources.getRulesFileName());
        }
        Map<String, String> sourceCode = legacyModelFiles.stream().collect(Collectors.toMap(generatedFile -> generatedFile.getPath().replace(".java", "").replace(File.separatorChar, '.'), generatedFile -> new String(generatedFile.getData(), StandardCharsets.UTF_8)));
        Map<String, byte[]> compiledClasses = DrlCompilerHelper.compileClasses(sourceCode, memoryCompilerClassLoader);
        return new DrlCallableClassesContainer(new FRI(basePath, "drl"), generatedRulesModels, compiledClasses);
    }

    static void addPackageDescr(PackageDescr packageDescr, Resource resource, Map<String, CompositePackageDescr> packages) {
        CompositePackageDescr compositePackageDescr = packages.computeIfAbsent(packageDescr.getNamespace(), CompositePackageDescr2 -> new CompositePackageDescr(packageDescr.getNamespace()));
        compositePackageDescr.addPackageDescr(resource, packageDescr);
    }

    static void parseAndAdd(DrlResourceHandler drlResourceHandler, Resource resource, Map<String, CompositePackageDescr> packages) {
        try {
            DrlCompilerHelper.addPackageDescr(drlResourceHandler.process(resource), resource, packages);
        }
        catch (IOException | DroolsParserException e) {
            throw new KieCompilerServiceException(e);
        }
    }

    static Map<String, byte[]> compileClasses(Map<String, String> sourcesMap, KieMemoryCompiler.MemoryCompilerClassLoader memoryClassLoader) {
        return KieMemoryCompiler.compileNoLoad(sourcesMap, (ClassLoader)memoryClassLoader, (JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE);
    }
}

