/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.util.io.FileSystemResource;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.drl.engine.compilation.model.DrlCallableClassesContainer;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.model.DrlPackageDescrSetResource;
import org.kie.drl.engine.compilation.utils.DrlCompilerHelper;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoSetResource;
import org.kie.memorycompiler.KieMemoryCompiler;

class DrlCompilerHelperTest {
    private static KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    private static Set<File> drlFiles;
    private static Set<PackageDescr> packageDescrs;

    DrlCompilerHelperTest() {
    }

    @BeforeAll
    static void setUp() throws IOException, DroolsParserException {
        memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        drlFiles = Files.walk(Paths.get("src/test/resources", new String[0]), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).collect(Collectors.toSet());
        KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration = new KnowledgeBuilderConfigurationImpl();
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(knowledgeBuilderConfiguration);
        packageDescrs = new HashSet<PackageDescr>();
        for (File drlFile : drlFiles) {
            FileSystemResource fileSystemResource = new FileSystemResource(drlFile);
            PackageDescr process = drlResourceHandler.process((Resource)fileSystemResource);
            packageDescrs.add(process);
        }
    }

    @Test
    void getDrlCallableClassesContainerFromPackageDescrResource() {
        String basePath = UUID.randomUUID().toString();
        DrlPackageDescrSetResource toProcess = new DrlPackageDescrSetResource(packageDescrs, basePath);
        DrlCallableClassesContainer retrieved = DrlCompilerHelper.getDrlCallableClassesContainer((EfestoSetResource)toProcess, (KieMemoryCompiler.MemoryCompilerClassLoader)memoryCompilerClassLoader);
        this.commonVerifyEfestoCompilationOutput((EfestoCompilationOutput)retrieved, basePath);
    }

    @Test
    void getDrlCallableClassesContainerFromFileResource() {
        String basePath = UUID.randomUUID().toString();
        DrlFileSetResource toProcess = new DrlFileSetResource(drlFiles, basePath);
        DrlCallableClassesContainer retrieved = DrlCompilerHelper.getDrlCallableClassesContainer((DrlFileSetResource)toProcess, (KieMemoryCompiler.MemoryCompilerClassLoader)memoryCompilerClassLoader);
        this.commonVerifyEfestoCompilationOutput((EfestoCompilationOutput)retrieved, basePath);
    }

    private void commonVerifyEfestoCompilationOutput(EfestoCompilationOutput toVerify, String baseBath) {
        ((ObjectAssert)Assertions.assertThat((Object)toVerify).isNotNull()).isInstanceOf(DrlCallableClassesContainer.class);
        DrlCallableClassesContainer retrieved = (DrlCallableClassesContainer)toVerify;
        Assertions.assertThat((String)retrieved.getFri().getModel()).isEqualTo("drl");
        Assertions.assertThat((String)retrieved.getFri().getBasePath()).isEqualTo("/" + baseBath);
        Assertions.assertThat((List)retrieved.getFullClassNames()).hasSize(2);
        Assertions.assertThat((Map)retrieved.getCompiledClassesMap()).hasSize(12);
    }
}

